<?php
/**
* 2007-2018 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2022 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

include_once(_PS_MODULE_DIR_.'orangemoneycmr/classes/OrangeMoneyCmrPayment.php');

class OrangeMoneyCMRFinalisationModuleFrontController extends ModuleFrontController
{
    public function postProcess()
    {
       
        $id_order = '';
        $action = '';

        $key = Tools::getValue('key');
        if ($key != '') {
            $id_order = $this->getOrderId($key);
            $action = $this->getAction($key);
        } else {
            Tools::redirect('index.php');
        }

        $order = new Order($id_order);

        if ($order->id) {
            $customer = new Customer($order->id_customer);
            $payment_details = OrangeMoneyCmrPayment::getPaymentDetails($order->reference);
            if (!$payment_details) {
                $this->module->writeInlogFile($this->module->l('There was an error: payment not found'), 'ERROR');
                Tools::redirect('index.php');
            }
            switch ($action) {
                case 'r':
                    if ($payment_details) {
                        $this->module->writeInlogFile($this->module->l('Checking payment status ...'), 'INFO');
                        $this->module->writeInlogFile($this->module->l('Setting request status header ...'), 'INFO');
                        $header = OrangeMoneyCmrPayment::setRequestHeader('payment_or_status_request', $this->module);

                        $this->module->writeInlogFile($this->module->l('Setting request status body ...'), 'INFO');
                        $data_string = OrangeMoneyCmrPayment::setRequestBody('status_request', $this->module, null, $payment_details);
                        if (!$data_string){
                            $this->module->writeInlogFile($this->module->l('Setting request status body failed'), 'ERROR');
                            Tools::redirect('index.php');
                        }

                        $this->module->writeInlogFile($this->module->l('Sending status request ...'), 'INFO');
                        $results = OrangeMoneyCmrPayment::sendRequest($this->module, $header, $data_string, $this->module->statusUrl);
                        if (!$results) {
                            Tools::redirect('index.php');
                        }
                        switch ($results['status']) {
                            case 'SUCCESS':
                                $this->module->writeInlogFile($this->module->l('The payment status is : SUCCESS'), 'INFO');
                                OrangeMoneyCmrPayment::updatePayment($payment_details, $results['status'], $results['txnid']);
                                $this->module->orangeMoneyOrderConfirmation($order, $customer, Configuration::get('PS_OS_PAYMENT'));
                                break;
                                
                            default:
                                $this->module->writeInlogFile($this->module->l('The payment status is : UNDEFINED'), 'ERROR');
                                $this->module->orangeMoneyOrderConfirmation($order, $customer, Configuration::get('PS_OS_ERROR'));
                                break;
                        }
                    } else {
                        $this->module->writeInlogFile($this->module->l('Checking the payment status failed with the following message: payment does not exist.'), 'ERROR');
                        $this->module->orangeMoneyOrderConfirmation($order, $customer, Configuration::get('PS_OS_ERROR'));
                      }
                    break;
                case 'c':
                    $this->module->writeInlogFile($this->module->l('Payment failed with the following message: payment cancelled.'), 'INFO');
                    OrangeMoneyCmrPayment::updatePayment($payment_details, 'CANCELED', '');
                    $this->module->orangeMoneyOrderConfirmation($order, $customer, Configuration::get('PS_OS_CANCELED'));
                    break;
                case 'n':
                    if ($_SERVER['REQUEST_METHOD'] == "POST") {
                        $this->module->writeInlogFile($this->module->l('Payment notification received...'), 'INFO');
                        $postBody = Tools::file_get_contents("php://input");

                        $response = json_decode($postBody);

                        if ($response) {
                            if ($payment_details->notif_token === $response->notif_token) {
                                if ($response->status == 'SUCCESS') {
                                    $this->module->writeInlogFile($this->module->l('Payment status is successfull'), 'INFO');
                                    OrangeMoneyCmrPayment::updatePayment($payment_details, $response->status, $response->txnid);
                                    $this->module->orangeMoneyOrderConfirmation($order, $customer, Configuration::get('PS_OS_PAYMENT'));
                                } else {
                                    $this->module->writeInlogFile($this->module->l('Payment failed with the following message: payment failed.').$postBody, 'ERROR');
                                    $this->module->orangeMoneyOrderConfirmation($order, $customer, Configuration::get('PS_OS_ERROR'));
                                }
                            } else {
                                $this->module->writeInlogFile($this->module->l('Payment failed with the following message: umatched token.').$postBody, 'ERROR');
                                $this->module->orangeMoneyOrderConfirmation($order, $customer, Configuration::get('PS_OS_ERROR'));
                            }
                        } else {
                            $this->module->writeInlogFile($this->module->l('Decoding JSON failed with the following message: ').json_last_error_msg(), 'ERROR');
                            $this->module->orangeMoneyOrderConfirmation($order, $customer, Configuration::get('PS_OS_ERROR'));
                        }
                    } else {
                        Tools::redirect('index.php');
                    }
                    break;
                default:
                    Tools::redirect('index.php');
                    break;
            }
        } else {
            $this->module->writeInlogFile($this->module->l('Payment failed with the following message: Order not found'), 'ERROR');
            Tools::redirect('index.php');
        }
    }

    /**
     * Gets the order id from the $key params
     */
    public function getOrderId($key)
    {
        return Tools::substr($key, 1);
    }

    /**
     * Gets the order id from the $key params
     */
    public function getAction($key)
    {
        return Tools::substr($key, 0, 1);
    }
}
