<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

abstract class RadiusdeliveryCore extends CarrierModule
{
    const GEOCODER_URL = 'https://geocode.search.hereapi.com/v1/geocode';
    const ROUTE_URL = 'https://router.hereapi.com/v8/routes';
    const CREATE_API_KEY_URL = 'https://platform.here.com/admin/apps?action=new-registration';
    const PRICE_FREE = 'PRICE_FREE';
    const PRICE_NATIVE = 'PRICE_NATIVE';
    const PRICE_DISTANCE = 'PRICE_DISTANCE';
    const PRICE_DISTANCE_RANGE = 'PRICE_DISTANCE_RANGE';
    const PRICE_DURATION = 'PRICE_DURATION';
    const PRICE_DURATION_RANGE = 'PRICE_DURATION_RANGE';
    const PRICE_MODE_NORMAL = 'PRICE_MODE_NORMAL';
    const PRICE_MODE_ROUNDED = 'PRICE_MODE_ROUNDED';
    const PRICE_MODE_PSYCHOLOGICAL = 'PRICE_MODE_PSYCHOLOGICAL';

    protected static function getCarriers()
    {
        $carriers = json_decode(Configuration::getGlobalValue('RADIUS_DELIVERY_CARRIERS'), true);
        if (!is_array($carriers)) {
            $carriers = array();
        }
        return $carriers;
    }

    public function getOrderShippingCost($cart, $shipping_cost)
    {
        if (isset($this->prices[$this->id_carrier])) {
            return $this->prices[$this->id_carrier];
        }

        $price = false;
        $shipping_cost = $shipping_cost;

        $id_address_delivery = $cart->id_address_delivery;

        if (!$id_address_delivery) {
            $this->prices[$this->id_carrier] = $price;
            return $price;
        }

        $carriers = self::getCarriers();

        if ($carriers && isset($carriers[$this->id_carrier])) {
            $carrier = $carriers[$this->id_carrier];

            $query = new DbQuery();
            $query->select('distance, duration');
            $query->from($this->name);
            $query->where('id_address = '.(int)$id_address_delivery.' AND id_carrier = '.(int)$this->id_carrier);
            $row = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($query);

            if (!$row) {
                $distance = $duration = -1;
                $destination = $this->formatAddress($id_address_delivery);
                $geocodeAddress = $this->geocodeAddress($destination);
                if ($geocodeAddress) {
                    $origin = $carrier['latitude'].','.$carrier['longitude'];
                    $matrix = $this->calculateMatrix($origin, $geocodeAddress->lat.','.$geocodeAddress->lng);
                    if ($matrix) {
                        $distance = $matrix['distance'];
                        $duration = $matrix['duration'];
                    }
                }

                Db::getInstance()->insert($this->name, array(
                    'id_address' => (int)$id_address_delivery,
                    'id_carrier' => (int)$this->id_carrier,
                    'distance' => (int)$distance,
                    'duration' => (int)$duration,
                ));
            } else {
                $distance = $row['distance'];
                $duration = $row['duration'];
            }

            if ($distance >= 0 && $duration >= 0) {
                $distance = $distance / 1000;
                $duration = $duration / 60;

                $without_taxes = Configuration::getGlobalValue('RADIUS_DELIVERY_TAXES_EXCLUDED');
                if (Configuration::getGlobalValue('RADIUS_DELIVERY_DISCOUNTS_DEDUCTED')) {
                    $cart_total = $cart->getOrderTotal(!$without_taxes, Cart::BOTH_WITHOUT_SHIPPING);
                } else {
                    $cart_total = $cart->getOrderTotal(
                        !$without_taxes,
                        version_compare(_PS_VERSION_, 1.7, '>=') ? Cart::ONLY_PRODUCTS : Cart::ONLY_PRODUCTS_WITHOUT_SHIPPING
                    );
                }
                $cart_weight = $cart->getTotalWeight();
                if ((isset($carrier['min_price']) && $carrier['min_price'] > 0 && $cart_total < $carrier['min_price'])
                    || (isset($carrier['max_price']) && $carrier['max_price'] > 0 && $cart_total > $carrier['max_price'])
                    || (isset($carrier['min_weight']) && $carrier['min_weight'] > 0 && $cart_weight < $carrier['min_weight'])
                    || (isset($carrier['max_weight']) && $carrier['max_weight'] > 0 && $cart_weight > $carrier['max_weight'])) {
                    $price = false;
                } elseif (in_array($carrier['billing'], array(self::PRICE_FREE, self::PRICE_DISTANCE, self::PRICE_DURATION))) {
                    $min_distance = isset($carrier['min_distance']) ? $carrier['min_distance'] : 0;
                    $max_distance = isset($carrier['max_distance']) ? $carrier['max_distance'] : 0;
                    $min_duration = isset($carrier['min_duration']) ? $carrier['min_duration'] : 0;
                    $max_duration = isset($carrier['max_duration']) ? $carrier['max_duration'] : 0;
                    if ((!$min_distance || $min_distance <= $distance) && (!$max_distance || $max_distance > $distance)
                        && (!$min_duration || $min_duration <= $duration) && (!$max_duration || $max_duration > $duration)) {
                        if ($carrier['billing'] === self::PRICE_FREE
                            || ($carrier['billing'] === self::PRICE_DISTANCE && isset($carrier['min_billing_distance']) && $carrier['min_billing_distance'] > 0 && $carrier['min_billing_distance'] > $distance)
                            || ($carrier['billing'] === self::PRICE_DURATION && isset($carrier['min_billing_duration']) && $carrier['min_billing_duration'] > 0 && $carrier['min_billing_duration'] > $duration)
                        ) {
                            $price = 0;
                        } else {
                            if (isset($carrier['min_billing_deduct']) && $carrier['min_billing_deduct']) {
                                $distance -= $carrier['min_billing_distance'];
                                if ($distance < 0) {
                                    $distance = 0;
                                }
                                $duration -= $carrier['min_billing_duration'];
                                if ($duration < 0) {
                                    $duration = 0;
                                }
                            }
                            if ($carrier['billing'] === self::PRICE_DISTANCE) {
                                $price = ($distance * $carrier['price']) + $carrier['base_price'];
                            } else {
                                $price = ($duration * $carrier['price']) + $carrier['base_price'];
                            }
                        }
                    }
                } elseif (in_array($carrier['billing'], array(self::PRICE_DISTANCE_RANGE, self::PRICE_DURATION_RANGE))) {
                    $value = $carrier['billing'] === self::PRICE_DISTANCE_RANGE ? $distance : $duration;
                    if (is_array($carrier['ranges'])) {
                        foreach ($carrier['ranges'] as $range) {
                            if ($value >= $range['min'] && $value < $range['max']) {
                                $price = $range['price'];
                                break;
                            }
                        }
                    }
                } elseif ($carrier['billing'] === self::PRICE_NATIVE) {
                    return $shipping_cost;
                }

                if ($price) {
                    $price = Tools::convertPrice($price, $cart->id_currency);
                    switch ($carrier['price_mode']) {
                        case self::PRICE_MODE_ROUNDED:
                            $price = Tools::ps_round($price);
                            break;
                        case self::PRICE_MODE_PSYCHOLOGICAL:
                            $price = Tools::ps_round($price) - 0.01;
                            break;
                    }
                    $price = $price < 0 ? 0 : $price;
                }
            }
        }
        $this->prices[$this->id_carrier] = $price;
        return $price;
    }
}
