<?php
/**
* 2013 - 2015 CleanDev
*
* NOTICE OF LICENSE
*
* This file is proprietary and can not be copied and/or distributed
* without the express permission of CleanDev
*
* @author    CleanPresta : www.cleanpresta.com <contact@cleanpresta.com>
* @copyright 2013 - 2015 CleanDev.net
* @license   You only can use module, nothing more!
*/

if (!defined('_PS_VERSION_'))
	exit;

if(!class_exists('CleanModule'))
    require_once(dirname(__FILE__) .'/CleanModule.php');
	
class CdHomeCategories extends CleanModule 
{
	private $_html = '';
	
	public function __construct() 
	{
		$this->name 		= 'cdhomecategories';
		$this->tab 			= 'front_office_features';
		$this->version 		= '1.0.0';
		$this->mprefix 		= "CDHC_";
		$this->reference 	= "CDHC";
		$this->addon_id 	= '20222'; // addon module id
		$this->module_key	= 'dca7177c66f4888a9843129cc012feff'; // addon key
		$this->author		= $this->l('CleanPresta');
		$this->ps_versions_compliancy['min'] = '1.5.0'; // min ps version
		 
		parent::__construct();
		
		$this->customerModule = true;
		$this->displayName 	= $this->l('Home Categories');
		$this->description 	= $this->l('Display custom categories on home page');
		$this->full_description = $this->l('Display custom categories on home page.'); 
		  
		//cleanpresta var
		$this->hooks = array('displayHome');
		
		$this->config_form = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Settings'),
					'icon' => 'icon-cogs'
				),
				'tabs' => array(
					'tab1' => $this->l('Categories'),
					'tab2' => $this->l('Options'),
				),
				'description' => $this->description, // can be success, error, warning
				'input' => array(
					// tab 1
					/*array(
						'type' => $this->formBoolType,
						'label' => $this->l('Display name'),
						'name' => 'CDHC_DISPLAY_NAME', 
						'is_bool' => true,
						'values' => array(
							array('id' => 'type_switch_on','value' => 1,'label' => $this->l('Yes')),
							array('id' => 'type_switch_off','value' => 0,'label' => $this->l('No'))
						),
						'tab' => 'tab2'
					),
					array(
						'type' => $this->formBoolType,
						'label' => $this->l('Display desciption'),
						'name' => 'CDHC_DISPLAY_DESCR', 
						'is_bool' => true,
						'values' => array(
							array('id' => 'type_switch_on','value' => 1,'label' => $this->l('Yes')),
							array('id' => 'type_switch_off','value' => 0,'label' => $this->l('No'))
						),
						'tab' => 'tab2'
					),
					 
					array(
						'type' => 'select',
						'label' => $this->l('Hover effect'),
						'name' => 'CDHC_HOVER_EFFECT', 
						'size' => 5,
						'options' => array(
							'query' => Zone::getZones(),
							'id' => 'id_zone',
							'name' => 'name'
						),
						'tab' => 'tab2'
					),*/
					
					array(
						'type' => 'categories',
						'name' => 'CDHC_HOME_CATEGORIES',
						'label' => $this->l('Categories'), 
						'tree' => array(
							'root_category' => 2,
							'id' => 'id_category',
							'name' => 'name_category',
							'use_checkbox' => true, // false to select multiple(chechbox) ...true to select one (radio)
							'selected_categories' => $this->getParamValue('CDHC_HOME_CATEGORIES', true),
						),
						'tab' => 'tab1'
					)
				),
				'submit' => array(
					'title' => $this->l('Save') 
				)
			)
		);
		
		//$this->initSpecialInput($this->config_form); //init form
		$this->configValues = $this->getConfigValues();
	}
	
	public function hookDisplayHome($param)
	{
		$param = $this->getConfigValues(); 
		$param['cdhc_home_categories'] = unserialize($param['cdhc_home_categories']);
		$this->context->smarty->assign(array(
			'param' => $param,
			 'homeSize' => Image::getSize(ImageType::getFormatedName('home')),
			'home_categories' => $this->getHomeCategories($this->context->language->id, $param['cdhc_home_categories']),
		));
		return $this->display(__FILE__, 'cdhomecategories.tpl');
    }
	
	
	public function getHomeCategories($id_lang, $ids = array())
	{
		if($result = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
			SELECT c.id_category, cl.name, cl.description, cl.link_rewrite
			FROM '._DB_PREFIX_.'category c
			LEFT JOIN '._DB_PREFIX_.'category_lang cl ON (c.id_category = cl.id_category AND cl.id_lang = '.(int)$id_lang.') 
			WHERE c.id_category IN ('.implode(',',$ids).')
			ORDER BY c.id_category ASC')
		){
			$link = $this->context->link;
			foreach($result as $key => &$row){
				$row['link'] = $link->getCategoryLink($row['id_category'], $row['link_rewrite']);
				$row['id_image'] = Tools::file_exists_cache(_PS_CAT_IMG_DIR_.$row['id_category'].'.jpg') ? (int)$row['id_category'] : Language::getIsoById($id_lang).'-default'; 
			}//var_dump($result);die();
			return $result;
		} 
		return false;
	}
}