<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
class QuotationFormController
{
    public function __construct()
    {
    }

    public static function answerForm($id_quotation, $id_element, $value, $id_form)
    {
        $id_currency = Context::getContext()->cookie->id_currency;
        if(Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'quot_field_val VALUES ('.(int)$id_quotation.', '.(int)$id_element.', "'.pSQL($value).'")'))
            return Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.'quot SET id_form = '.(int)$id_form.', id_currency = '.(int)$id_currency.' WHERE id_quot = '.(int)$id_quotation);
    }

    public static function getFormById($id_quotation = null)
    {
        if(is_null($id_quotation))
            return false;
        $query = 'SELECT * FROM '._DB_PREFIX_.'quot_form WHERE id_form = '.(int)$id_quotation;
        $forms =  Db::getInstance()->ExecuteS($query);
        $results = array();

        foreach($forms as $form)
        {
            $results[$form['id_lang']]['name'] = $form['form_name'];
            $results[$form['id_lang']]['content'] = Tools::file_get_contents(dirname(__FILE__).'/../forms/'.$form['id_form'].'_'.$form['id_lang'].'.tpl');
            // p(dirname(__FILE__).'/../forms/'.$form['id_form'].'_'.$form['id_lang'].'.tpl');
        }
        // d('ok');

        return $results;
    }

    public static function getForms($id_shop = null, $id_shop_group = null, $id_lang = null, $active = null)
    {
        $query = 'SELECT * FROM '._DB_PREFIX_.'quot_form';
        if(is_null($id_shop) && is_null($id_shop_group) && is_null($id_lang) && is_null($active))
            $query .= ' GROUP BY id_form ORDER BY id_form';
        else
        {
            $query .= ' WHERE';
            $cond = '';
            if(!is_null($id_shop))
            {
                if(is_array($id_shop))
                {
                    array_map('intval', $id_shop);
                    $id_shop = implode(',', $id_shop);
                }
                else
                    $id_shop = (int)$id_shop;

                $cond .= ' id_shop IN (' . $id_shop . ')';
            }
            if(!is_null($id_shop_group))
            {
                if(is_array($id_shop_group))
                {
                    array_map('intval', $id_shop_group);
                    $id_shop_group = implode(',', $id_shop_group);
                }
                else
                    $id_shop_group = (int)$id_shop_group;

                if(!is_null($id_shop))
                    $cond .= ' OR';
                $cond .= ' id_shop_group IN (' . $id_shop_group . ')';
            }
            $query .= '(' . $cond . ')';
            if(!is_null($id_lang))
            {
                if(!is_null($id_shop) || !is_null($id_shop_group))
                    $query .= ' AND';
                $query .= ' id_lang = ' . (int)$id_lang;
            }
            if(!is_null($active))
            {
                if(!is_null($id_shop) || !is_null($id_lang) || !is_null($id_shop_group))
                    $query .= ' AND';
                $query .= ' active = ' . (int)$active;
            }
        }
        return Db::getInstance()->ExecuteS($query);
    }

    public static function getActiveForms($id_shop = null, $id_shop_group = null, $id_lang = null, $active = null)
    {
        $query = 'SELECT * FROM '._DB_PREFIX_.'quot_form';
        if(is_null($id_shop) && is_null($id_shop_group) && is_null($id_lang) && is_null($active))
            $query .= ' WHERE active = 1 GROUP BY id_form ORDER BY id_form';
        else
        {
            $query .= ' WHERE';
            $cond = '';
            if(!is_null($id_shop))
            {
                if(is_array($id_shop))
                {
                    array_map('intval', $id_shop);
                    $id_shop = implode(',', $id_shop);
                }
                else
                    $id_shop = (int)$id_shop;

                $cond .= ' id_shop IN (' . $id_shop . ')';
            }
            if(!is_null($id_shop_group))
            {
                if(is_array($id_shop_group))
                {
                    array_map('intval', $id_shop_group);
                    $id_shop_group = implode(',', $id_shop_group);
                }
                else
                    $id_shop_group = (int)$id_shop_group;

                if(!is_null($id_shop))
                    $cond .= ' OR';
                $cond .= ' id_shop_group IN (' . $id_shop_group . ')';
            }
            $query .= '(' . $cond . ')';
            if(!is_null($id_lang))
            {
                if(!is_null($id_shop) || !is_null($id_shop_group))
                    $query .= ' AND';
                $query .= ' id_lang = ' . (int)$id_lang;
            }
            if(!is_null($active))
            {
                if(!is_null($id_shop) || !is_null($id_lang) || !is_null($id_shop_group))
                    $query .= ' AND';
                $query .= ' active = ' . (int)$active;
            }
        }

        return Db::getInstance()->ExecuteS($query);
    }

    public static function getForm($id_shop = null, $id_shop_group = null, $id_lang = null, $active = null)
    {
        $form = self::getForms($id_shop, $id_shop_group, $id_lang, $active);
        if(isset($form[0]))
            return $form;
        else
            return false;
    }

    public static function getMaxId()
    {
        $query = 'SELECT MAX(id_form) FROM '._DB_PREFIX_.'quot_form';
        return Db::getInstance()->getValue($query);
    }

    public static function activate($id_quotation, $activate)
    {
        if($activate == 1)
        {
            $query = 'UPDATE '._DB_PREFIX_.'quot_form SET active = 0';
            Db::getInstance()->Execute($query);
        }
        $query = 'UPDATE '._DB_PREFIX_.'quot_form SET active = '.(int)$activate.' WHERE id_form = '.(int)$id_quotation;
        return Db::getInstance()->Execute($query);
    }

    public static function updateIdForm($id_quotation, $id_form)
    {
        $query = 'UPDATE '._DB_PREFIX_.'quot SET id_form = '.(int)$id_form.' WHERE id_quot = '.(int)$id_quotation;
        return Db::getInstance()->Execute($query);
    }

    public static function getQuotations($id_shop = null, $id_customer = null, $guest = null, $statut = null, $order_how = null, $order_by = null, $employee = true)
    {
        $id_shop = Context::getContext()->shop->id;
        $id_shop_group = Context::getContext()->shop->id_shop_group;
        $iso_lang = Language::getIsoById(Context::getContext()->employee->id_lang);

        $query = 'SELECT q.* , qp.quantity as quantity, qf.form_name, qs.value AS statut, COUNT(DISTINCT(qm.id_message)) as unread, c.lastname, c.firstname
                FROM  `'._DB_PREFIX_.'quot` q
                LEFT JOIN '._DB_PREFIX_.'quot_product qp ON q.id_quot = qp.id_quot
                LEFT JOIN '._DB_PREFIX_.'quot_form qf ON q.id_form = qf.id_form
                INNER JOIN '._DB_PREFIX_.'quot_statut qs ON (q.id_statut = qs.id_statut AND (qs.id_lang = "'.pSQL($iso_lang).'" OR qs.id_lang = "en"))
                LEFT JOIN '._DB_PREFIX_.'quot_messages qm ON (q.id_quot = qm.id_quot AND is_read = 0';

        if($employee)
            $query .= ' AND qm.id_employee = 0';
        else
            $query .= ' AND qm.id_employee > 0';
        $query .= ')';
        $query .= ' INNER JOIN '._DB_PREFIX_.'customer c ON q.id_customer = c.id_customer';

        $query .= ' WHERE q.id_shop = '.(int)$id_shop.' OR q.id_shop_group = '.(int)$id_shop_group.' AND qm.is_read = 0';

        $query .= ' GROUP BY q.id_quot';

        $return = array();
        $x = 0;
        foreach(Db::getInstance()->ExecuteS($query) as $result)
        {
            $query = 'SELECT SUM(qp.quantity) FROM  `'._DB_PREFIX_.'quot_product` qp WHERE qp.id_quot = '.(int)$result['id_quot'];
            $result['real_quantity'] = Db::getInstance()->getValue($query);
            $return[] = $result;
        }

        // d($return);

        return $return;
    }

    public static function getStatusColor($id_status)
    {
        // d($id_status);
    }

    public static function getUnreadMessages($id_quotation, $employee = true)
    {
        $query = 'SELECT COUNT(DISTINCT(qm.id_message)) as unread
                FROM  '._DB_PREFIX_.'quot_messages qm';

        $query .= ' WHERE qm.id_quot = '.(int)$id_quotation.' AND qm.is_read = 0';
        if($employee)
            $query .= ' AND qm.id_employee = 0';
        else
            $query .= ' AND qm.id_employee > 0';

        $result = Db::getInstance()->ExecuteS($query);

        return $result[0]['unread'];
    }

    public static function getQuotationsByCustomerId($id_shop = null, $id_customer = null, $id_lang = null, $employee = false)
    {
        if(is_null($id_shop))
            $id_shop = Context::getContext()->shop->id;
        if(is_null($id_customer))
            $id_customer = Context::getContext()->customer->id;
        if(is_null($id_lang))
            $id_lang = Context::getContext()->customer->id_lang;

        if(Language::getIsoById($id_lang) != 'fr' && Language::getIsoById($id_lang) != 'en')
            $iso_lang = 'en';
        else
            $iso_lang = Language::getIsoById($id_lang);

        $query = 'SELECT q.id_quot, qf.form_name, q.id_cart, q.id_statut, qs.value as statut_value, qs.color as statut_color, COUNT(DISTINCT(qm.id_message)) as unread
                FROM  `'._DB_PREFIX_.'quot` q
                INNER JOIN '._DB_PREFIX_.'quot_form qf ON q.id_form = qf.id_form
                INNER JOIN '._DB_PREFIX_.'quot_statut qs ON qs.id_statut = q.id_statut
                LEFT JOIN '._DB_PREFIX_.'quot_messages qm ON (qm.id_quot = q.id_quot AND is_read = 0';
        if($employee)
            $query .= ' AND qm.id_employee = 0';
        else
            $query .= ' AND qm.id_employee > 0';

        $query .= ')';
        $query .= ' WHERE q.id_shop = '.(int)$id_shop.' AND q.id_customer = '.(int)$id_customer.' AND qf.id_lang = '.(int)$id_lang.' AND (qs.id_lang = "'.$iso_lang.'")';
        $query .= ' GROUP BY q.id_quot';

        return Db::getInstance()->ExecuteS($query);
    }

    public static function getStatuts()
    {
        $iso_lang = Language::getIsoById(Context::getContext()->employee->id_lang);
        $query = 'SELECT * FROM '._DB_PREFIX_.'quot_statut WHERE (id_lang = "'.pSQL($iso_lang).'")';
        $results = Db::getInstance()->ExecuteS($query);
        if(empty($results))
        {
            $query = 'SELECT * FROM '._DB_PREFIX_.'quot_statut WHERE (id_lang = "en")';
            $results = Db::getInstance()->ExecuteS($query);
        }
        return $results;
    }

    public static function setStatutByCart($cart_id, $id_statut, $sendMail = true)
    {
        // $query = 'UPDATE '._DB_PREFIX_.'quot SET id_statut = '.(int)$id_statut.' WHERE id_cart = '.(int)$cart_id;
        // return Db::getInstance()->Execute($query);
        require_once dirname(__FILE__).'/../classes/QuotationObj.class.php';
        $query = 'SELECT id_quot FROM '._DB_PREFIX_.'quot WHERE id_cart = '.(int)$cart_id;
        return QuotationObj::updateStatut(Db::getInstance()->getValue($query), $id_statut, $sendMail);
    }

    public static function setStatut($id_quotation, $id_statut)
    {
        $query = 'UPDATE '._DB_PREFIX_.'quot SET id_statut = '.(int)$id_statut.' WHERE id_quot = '.(int)$id_quotation;
        return Db::getInstance()->Execute($query);
    }

    public static function removeProduct($id_quotation, $id_product, $id_combination)
    {
        $query = 'DELETE FROM '._DB_PREFIX_.'quot_product WHERE id_quot = '.(int)$id_quotation.' AND id_product = '.(int)$id_product.' AND id_combination = '. (int)$id_combination;
        return Db::getInstance()->Execute($query);
    }

    public static function getQuotationDetails($id_quotation)
    {
        if(isset(Context::getContext()->customer->id_lang))
            $id_lang = Context::getContext()->customer->id_lang;
        if(!isset($id_lang))
            $id_lang = Context::getContext()->employee->id_lang;
        $iso_lang = Language::getIsoById($id_lang);

        $query = 'SELECT *
            FROM  `'._DB_PREFIX_.'quot` q
            LEFT JOIN '._DB_PREFIX_.'customer c ON q.id_customer = c.id_customer
            INNER JOIN '._DB_PREFIX_.'quot_form qf ON q.id_form = qf.id_form
            INNER JOIN '._DB_PREFIX_.'quot_statut qs ON (q.id_statut = qs.id_statut )
            LEFT JOIN '._DB_PREFIX_.'cart_rule cr ON q.id_cart_rule = cr.id_cart_rule
            WHERE q.id_quot = '.(int)$id_quotation.'
            AND qf.id_lang = "'.(int)$id_lang.'" AND (qs.id_lang = "'.pSQL($iso_lang).'" OR qs.id_lang = "en")';

        return Db::getInstance()->ExecuteS($query);
    }

    public static function getFormDetails($id_form, $id_lang)
    {
        $iso_lang = Language::getIsoById($id_lang);
        $query = 'SELECT * FROM  `'._DB_PREFIX_.'quot_form` qf WHERE qf.id_form = '.(int)$id_form.' AND id_lang = "'.pSQL($iso_lang).'"';
        return Db::getInstance()->ExecuteS($query);
    }

    public static function getAnswer($id_quotation, $id_lang)
    {
        $query = 'SELECT *
        FROM  `'._DB_PREFIX_.'quot` q
        JOIN '._DB_PREFIX_.'quot_form_field qf ON q.id_form = qf.id_form
        JOIN '._DB_PREFIX_.'quot_field_val qfv ON id_form_field = qf.id
        WHERE q.id_quot = '.(int)$id_quotation.' AND q.id_quot = qfv.id_quot AND qf.id_lang = '.(int)$id_lang.' AND qfv.value !=  "0" ORDER BY qf.pos';

        $answers = array();

        $prev_name = '';
        $temp_val = '';
        foreach(Db::getInstance()->ExecuteS($query) as $answer)
        {
            // p($answer);
            if($answer['id_parent'] == 0)
            {
                $name 	= $answer['name'];
                $value	= $answer['value'];
                $id		= $answer['id_form_field'];
            }
            else
            {
                $name = Db::getInstance()->getValue('SELECT name
                FROM '._DB_PREFIX_.'quot_form_field qff
                WHERE qff.id = '.(int)$answer['id_parent'].' AND qff.id_lang = '.(int)$id_lang);
                $value 	= $answer['label'];
                $id		= $answer['id_parent'];
            }
            if($prev_name == $name)
            {
                if(Tools::strlen($temp_val) > 0)
                    $temp_val .= ',';
                $temp_val .= $value;
            }
            else
                $temp_val = $value;

            $answers[$id]['name'] = $name;
            $answers[$id]['value'] = $temp_val;
            $answers[$id]['type_field'] = $answer['type_field'];
            $prev_name = $name;
        }
        return $answers;
    }
}
