<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
class AdminQuotationController extends ModuleAdminController
{

    /** @var protected array cache filled with lang informations */
    protected static $rule_cache;

    public function ajaxProcessEditFormElement()
    {
        require_once dirname(__FILE__).'/../../classes/FormField.class.php';
        $val 			= trim(Tools::getValue('val'));
        $id_lang		= (int)trim(Tools::getValue('id_lang'));
        $id_element		= (int)trim(Tools::getValue('id_element'));

        if($id_element == 0)
            $id_element = 'NULL';
        FormField::edit($id_element, $id_lang, $val);
    }
    /**
    * Save one form element
    *
    * @access see JS
    * @param int $id_rule
    * @param string $role
    * @param string $type
    * @return html
    */
    public function ajaxProcessSaveFormElement()
    {
        require_once dirname(__FILE__).'/../../classes/FormField.class.php';
        $id_form 		= (int)trim(Tools::getValue('id_form'));
        $type_field 	= trim(Tools::getValue('type_field'));
        $val 			= trim(Tools::getValue('val'));
        $pos 			= (int)trim(Tools::getValue('pos'));
        $id_lang		= (int)trim(Tools::getValue('id_lang'));
        $id_parent		= (int)trim(Tools::getValue('id_parent'));
        $id_element		= (int)trim(Tools::getValue('id_element'));

        if($id_element == 0)
            $id_element = 'NULL';

        $field = new FormField($id_element, $id_form, $val, $val, $type_field, $val, $id_parent, $pos, $id_lang);
        echo $field->save();
    }

    /**
    * Save html form
    */
    public function ajaxProcessSaveForm()
    {
        require_once dirname(__FILE__).'/../../classes/Form.class.php';
        $id_form 		= (int)trim(Tools::getValue('id_form'));
        $form_name	 	= trim(Tools::getValue('form_name'));
        $id_lang		= (int)trim(Tools::getValue('id_lang'));
        $active			= (int)Tools::getValue('active');

        $form = new Form($id_form, $id_lang, $form_name, $active);

        if($form->save())
        {
            $file = fopen(dirname(__FILE__).'/../../forms/'.$id_form.'_'.$id_lang.'.tpl', 'w+');
            $puts = fputs($file, Tools::getValue('content'));
            fclose($file);

            echo $puts;
        }
        else
            echo 0;
    }

    public function ajaxProcessSetQuotPrefix()
    {
        Configuration::updateValue('QUOTATION_PREFIX', Tools::getValue('prefix'));
    }
    public function ajaxProcessSetLiveMode()
    {
        Configuration::updateValue('QUOTATION_LIVE_MODE', Tools::getValue('val'));
    }

    public function ajaxProcessSetIpAdress()
    {
        Configuration::updateValue('QUOTATION_IP', Tools::getRemoteAddr());
        echo Tools::getRemoteAddr();
    }

    public function ajaxProcessSetIpAdressManually()
    {
        Configuration::updateValue('QUOTATION_IP', Tools::getValue('ip_adress'));
    }

    public function ajaxProcessActivateQuotation()
    {
        require_once dirname(__FILE__).'/../QuotationFormController.class.php';
        echo (int)QuotationFormController::activate(Tools::getValue('id_quotation'), Tools::getValue('active'));
    }

    public function displayAjaxGetForm()
    {
        require_once dirname(__FILE__).'/../QuotationFormController.class.php';
        echo Tools::jsonEncode(QuotationFormController::getFormById(Tools::getValue('id_quotation')));
    }

    public static function ajaxProcessSetStatut()
    {
        $id_quotation 	= Tools::getValue('id_quotation');
        $id_statut 		= Tools::getValue('id_statut');
        require_once dirname(__FILE__).'/../../classes/QuotationObj.class.php';
        echo QuotationObj::updateStatut($id_quotation, $id_statut, true);
    }

    public static function ajaxProcessDeleteQuotation()
    {
        $sql = array();
        $sql[] = 'DELETE FROM '._DB_PREFIX_.'quot WHERE id_quot = '.(int)Tools::getValue('id_quotation');
        $sql[] = 'DELETE FROM '._DB_PREFIX_.'quot_field_val WHERE id_quot = '.(int)Tools::getValue('id_quotation');
        $sql[] = 'DELETE FROM '._DB_PREFIX_.'quot_messages WHERE id_quot = '.(int)Tools::getValue('id_quotation');
        $sql[] = 'DELETE FROM '._DB_PREFIX_.'quot_product WHERE id_quot = '.(int)Tools::getValue('id_quotation');

        foreach ($sql as $query) {
            if (Db::getInstance()->execute($query) == false) {
                $return = false;
            }
        }
    }

    public static function ajaxProcessGetUnreadMessages()
    {
        require_once dirname(__FILE__).'/../QuotationFormController.class.php';
        echo QuotationFormController::getUnreadMessages(Tools::getValue('id_quotation'), Tools::getValue('employee'));
    }

    public static function ajaxProcessSetReadMessage()
    {
        $query = 'UPDATE '._DB_PREFIX_.'quot_messages SET is_read = 1 WHERE id_quot = '.(int)Tools::getValue('id_quotation');
        if(Tools::getValue('employee'))
            $query .= ' AND id_employee = 0';
        else
            $query .= ' AND id_employee > 0';

        echo Db::getInstance()->Execute($query);
    }

    public static function ajaxProcessGetQuotationDetails()
    {
        require_once dirname(__FILE__).'/../QuotationFormController.class.php';
        require_once dirname(__FILE__).'/../../classes/QuotationObj.class.php';

        $id_quotation = Tools::getValue('id_quotation');

        $quotation = new QuotationObj($id_quotation, null);
        $products = $quotation->init(true, null, false, false);

        $quotation_details = QuotationFormController::getQuotationDetails($id_quotation);

        $form_details = QuotationFormController::getFormDetails($id_quotation, Context::getContext()->employee->id_lang);

        $context = Context::getContext();

        $context->smarty->assign('quotation_products', $products['products']);
        $context->smarty->assign('total_cart', $products['total_cart']);
        $context->smarty->assign('total_product', $products['total_product']);

        $reductionAmount = $quotation->getCartRuleValue();
        if((float)$reductionAmount == 0)
            $reductionAmount = 0;
        $context->smarty->assign('reduction_amount', $reductionAmount);

        $totalWithDiscount = $products['total_cart']-$reductionAmount;
        if($totalWithDiscount < 0)
            $totalWithDiscount = 0;

        $context->smarty->assign('total_quotation', $totalWithDiscount);

        if($quotation_details[0]['reduction_amount'] > 0)
            $cart_rule_value = $quotation_details[0]['reduction_amount'];
        else
            $cart_rule_value = 0;

        $context->smarty->assign('quotation_details', $quotation_details[0]);
        $context->smarty->assign('statuts', QuotationFormController::getStatuts());
        $context->smarty->assign('cart_rule_value', $cart_rule_value);
        $context->smarty->assign('quotation_answers', QuotationFormController::getAnswer($id_quotation, Context::getContext()->employee->id_lang));
        $context->smarty->assign('form_details', $form_details);

        $id_currency = $quotation->getIdCurrency();
        if(!isset($id_currency))
            $id_currency = Currency::getDefaultCurrency()->id;

        $currency = new Currency($id_currency);

        $context->smarty->assign('id_currency', $quotation->getIdCurrency());
        $context->smarty->assign('currency_sign', $currency->getSign());

        $context->smarty->assign('canCreateCartRule', 1);
        $context->smarty->assign('is_customer', false);
        $context->smarty->assign('tax', Group::getPriceDisplayMethod(Customer::getDefaultGroupId($quotation->getIdCustomer())));

        exit($context->smarty->fetch(dirname(__FILE__).'/../../views/templates/admin/tabs/quotation_detail.tpl'));
    }

    public static function ajaxProcessSendMessage()
    {
        $id_quotation 	= Tools::getValue('id_quotation');
        $message 		= Tools::getValue('message');
        $id_employee 	= Context::getContext()->employee->id;
        require_once dirname(__FILE__).'/../MessageController.class.php';
        echo MessageController::sendMessage($id_quotation, $message, $id_employee);
    }

    public static function ajaxProcessGetMessages()
    {
        $id_quotation 	= Tools::getValue('id_quotation');
        require_once dirname(__FILE__).'/../MessageController.class.php';
        $messages = MessageController::getMessages($id_quotation);

        $context = Context::getContext();
        $context->smarty->assign('messages', $messages);
        $context->smarty->assign('front', 0);

        echo $context->smarty->fetch(dirname(__FILE__).'/../../views/templates/admin/tabs/modals/messagesList.tpl');
    }

    public static function ajaxProcessGetDateTime()
    {
        echo date('m/d/Y H:i:s', time());
    }

    public static function ajaxProcessCreateCart()
    {
        require_once dirname(__FILE__).'/../../classes/QuotationObj.class.php';
        $id_quotation 	= Tools::getValue('id_quotation');
        $id_cart		= Tools::getValue('id_cart');

        if($id_cart == 0)
            $id_cart = null;
        $quotation = new QuotationObj($id_quotation);
        $products = $quotation->getProducts();

        $id_customer = $quotation->getIdCustomer();
        $cart = new Cart($id_cart);
        $cart->id_customer = $id_customer;
        $cart->id_currency = Configuration::get('PS_CURRENCY_DEFAULT');
        $cart->save();
        $sql = 'DELETE FROM '._DB_PREFIX_.'cart_product
                WHERE id_cart = '.(int)$cart->id;

        Db::getInstance()->execute($sql);
        foreach($products as $product)
        {
            $sql = 'REPLACE INTO '._DB_PREFIX_.'cart_product
                VALUES (
                    '.(int)$cart->id.',
                    '.(int)$product['id_product'].',
                    0,
                    '.(int)Shop::getContextShopId().',
                    '.(int)$product['id_combination'].',
                    '.(int)$product['quantity'].',
                    NOW())';

            Db::getInstance()->execute($sql);
        }
        Db::getInstance()->execute('UPDATE `'._DB_PREFIX_.'quot` SET id_cart = '.(int)$cart->id.' WHERE id_quot = '.(int)$id_quotation);
        echo $cart->id;
        die;
    }

    public static function ajaxProcessCreateCartRule()
    {
        require_once dirname(__FILE__).'/../DiscountController.class.php';
        require_once dirname(__FILE__).'/../QuotationFormController.class.php';
        $id_cart_rule 	= Tools::getValue('id_cart_rule');
        $tax 			= Tools::getValue('tax');
        $id_currency	= Tools::getValue('id_currency');
        if($id_cart_rule == 0)
            $id_cart_rule = null;
        $id_cart = Tools::getValue('id_cart');
        $id_quot = Tools::getValue('id_quotation');

        if($tax == 1)
            $tax = 0;
        else
            $tax = 1;

        $new_id_cart_rule = DiscountController::createDiscount($id_cart, Tools::getValue('cart_rule_value'), $id_cart_rule, Configuration::get('QUOTATION_PREFIX').''.$id_quot, $tax, $id_currency);
        Db::getInstance()->execute('UPDATE `'._DB_PREFIX_.'quot` SET id_cart_rule = '.(int)$new_id_cart_rule.' WHERE id_quot = '.(int)$id_quot);
        QuotationFormController::setStatut($id_quot, 3);
        echo $new_id_cart_rule;
    }
}
