<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
class quotationcustomerQuotationsModuleFrontController extends FrontController
{
    private static function checkHack($id_customer)
    {
        if($id_customer != Context::getContext()->customer->id)
            exit('Hack ...');
    }

    public function init() {
        $this->page_name = 'module-quotation-customerquotation';
        parent::init();
    }
    public function initContent()
    {
        $this->guestAllowed = true;
        $this->display_column_left = false;
        parent::initContent();

        require_once dirname(__FILE__).'/../QuotationFormController.class.php';
        $quotations = QuotationFormController::getQuotationsByCustomerId();

        // d($quotations);
        $this->context->smarty->assign('quotations', $quotations);

        $this->context->smarty->assign('id_quot', Tools::getValue('id_quot'));
        $this->context->smarty->assign('uri', _PS_BASE_URL_.__PS_BASE_URI__);
        $this->context->smarty->assign('order_link', $this->context->link->getPageLink('order'));

        $this->context->controller->addJS(_PS_MODULE_DIR_.'quotation/js/ckeditor/ckeditor.js');
        $this->context->controller->addCSS('//maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css');

        $this->template = dirname(__FILE__).'/../../views/templates/front/customerQuotations.tpl';
    }
    public function displayAjaxGetQuotationDetails()
    {
        require_once dirname(__FILE__).'/../QuotationFormController.class.php';
        require_once dirname(__FILE__).'/../../classes/QuotationObj.class.php';

        $id_quotation = Tools::getValue('id_quotation');

        $quotation = new QuotationObj($id_quotation, null);
        $products = $quotation->init(true, null, false, false);

        self::checkHack($quotation->getIdCustomer());

        $quotation_details = QuotationFormController::getQuotationDetails($id_quotation);
        $form_details = QuotationFormController::getFormDetails($id_quotation, Context::getContext()->customer->id_lang);


        $context = Context::getContext();

        $context->smarty->assign('quotation_products', $products['products']);
        $context->smarty->assign('total_cart', $products['total_cart']);
        $context->smarty->assign('total_product', $products['total_product']);
        $reductionAmount = $quotation->getCartRuleValue();
        $context->smarty->assign('reduction_amount', $reductionAmount);

        $totalWithDiscount = $products['total_cart']-$reductionAmount;
        if($totalWithDiscount < 0)
            $totalWithDiscount = 0;
        $context->smarty->assign('total_quotation', $totalWithDiscount);

        $context->smarty->assign('quotation_details', $quotation_details[0]);
        $context->smarty->assign('quotation_answers', QuotationFormController::getAnswer($id_quotation, Context::getContext()->customer->id_lang));
        $context->smarty->assign('form_details', $form_details);

        $id_currency = $quotation_details[0]['id_currency'];
        if(!isset($id_currency))
            $sign = $context->currency->sign;
        else
        {
            $currency = new Currency($id_currency);
            $sign = $currency->getSign();
        }

        $context->smarty->assign('currency_sign', $context->currency->sign);
        $context->smarty->assign('can_modify', $quotation_details[0]['id_statut'] == 1);
        $this->context->smarty->assign('canCreateCartRule', 0);
        $this->context->smarty->assign('is_customer', true);
        $this->context->smarty->assign('tax', Group::getPriceDisplayMethod(Context::getContext()->customer->id_default_group));

        echo $context->smarty->fetch(dirname(__FILE__).'/../../views/templates/admin/tabs/quotation_detail.tpl');
    }

    public function displayAjaxModifyQuotation()
    {
        require_once dirname(__FILE__).'/../../classes/QuotationObj.class.php';
        $id_quotation = Tools::getValue('id_quotation');
        $quot = new QuotationObj($id_quotation);
        $quot->init();
        self::checkHack($quot->getIdCustomer());
        QuotationObj::updateStatut($id_quotation, 7);
    }

    public function displayAjaxGetMessages()
    {
        require_once dirname(__FILE__).'/../MessageController.class.php';
        require_once dirname(__FILE__).'/../../classes/QuotationObj.class.php';
        $id_quotation = Tools::getValue('id_quotation');
        self::checkHack(QuotationObj::getIdCustomerStatic($id_quotation));
        $messages = MessageController::getMessages($id_quotation);

        $this->context->smarty->assign('messages', $messages);
        $this->context->smarty->assign('front', 1);

        echo $this->context->smarty->fetch(dirname(__FILE__).'/../../views/templates/admin/tabs/modals/messagesList.tpl');
    }

    public function displayAjaxSendMessage()
    {
        $id_quotation 	= Tools::getValue('id_quotation');
        $message 		= Tools::getValue('message');
        $id_customer 	= 0;
        require_once dirname(__FILE__).'/../MessageController.class.php';
        require_once dirname(__FILE__).'/../../classes/QuotationObj.class.php';
        self::checkHack(QuotationObj::getIdCustomerStatic($id_quotation));
        echo MessageController::sendMessage($id_quotation, $message, $id_customer);
    }

    public function displayAjaxGetDateTime()
    {
        echo date('d/m/Y H:i:s', time());
    }

    public function displayAjaxSetCart()
    {
        $this->context->cookie->id_cart = (int)Tools::getValue('id_cart');
        echo 1;
    }

    public static function displayAjaxGetUnreadMessages()
    {
        require_once dirname(__FILE__).'/../QuotationFormController.class.php';
        require_once dirname(__FILE__).'/../../classes/QuotationObj.class.php';
        self::checkHack(QuotationObj::getIdCustomerStatic(Tools::getValue('id_quotation')));
        echo QuotationFormController::getUnreadMessages(Tools::getValue('id_quotation'), (bool)Tools::getValue('employee'));
    }

    public static function displayAjaxSetReadMessage()
    {
        require_once dirname(__FILE__).'/../../classes/QuotationObj.class.php';
        self::checkHack(QuotationObj::getIdCustomerStatic(Tools::getValue('id_quotation')));
        $query = 'UPDATE '._DB_PREFIX_.'quot_messages SET is_read = 1 WHERE id_quot = '.(int)Tools::getValue('id_quotation');
        $query .= ' AND id_employee = 1';

        echo Db::getInstance()->Execute($query);
    }
}
