<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
class quotationquotationModuleFrontController extends FrontController
{
    public function init() {
        $this->page_name = 'module-quotation-quotation';
        parent::init();
    }
    public function initContent()
    {
        $this->guestAllowed = true;
        $this->display_column_left = false;
        parent::initContent();
        $context = Context::getContext();
        $id_lang = $context->cart->id_lang;
        $id_shop = $context->cart->id_shop;
        $id_shop_group = $context->cart->id_shop_group;

        require_once dirname(__FILE__).'/../QuotationFormController.class.php';

        $form = QuotationFormController::getForm(array(0, $id_shop), array(0, $id_shop_group), $id_lang, 1);

        $id_form = $form[0]['id_form'];
        $form = Tools::file_get_contents(dirname(__FILE__).'/../../forms/'.$form[0]['id_form'].'_'.$form[0]['id_lang'].'.tpl');

        $this->context->smarty->assign('id_quot', Context::getContext()->cookie->id_quotation);
        $this->context->smarty->assign('id_form', $id_form);
        $this->context->smarty->assign('form', $form);
        $this->context->smarty->assign('path', 'Quotation');
        $this->context->smarty->assign('logged', $context->customer->logged);
        $this->context->smarty->assign('tax', Group::getPriceDisplayMethod(Context::getContext()->customer->id_default_group));
        $this->context->smarty->assign('PS_CATALOG_MODE', Configuration::get('PS_CATALOG_MODE'));

        $this->template = dirname(__FILE__).'/../../views/templates/front/quotationsList.tpl';
    }

    public function displayAjaxAddProduct()
    {
        require_once dirname(__FILE__).'/../../classes/QuotationObj.class.php';
        $is_guest = !(int)Context::getContext()->customer->id > 0;

        if(!$is_guest){
            $id_guest = null;
            $id_customer = (int)Context::getContext()->customer->id;
        }
        else
        {
            $id_guest = (int)Context::getContext()->customer->id_guest;
            $id_customer = null;
        }

        if(isset(Context::getContext()->cookie->id_quotation) && Context::getContext()->cookie->id_quotation > 0)
            $id_quotation = (int)Context::getContext()->cookie->id_quotation;
        else
            $id_quotation = null;

        $quotation = new QuotationObj($id_quotation, $id_customer, $id_guest, Tools::getValue('id_shop'), null, 0);

        $id_quotation = $quotation->save();
        $quotation->init();
        if($id_quotation > 0)
        {
            Context::getContext()->cookie->__set('id_quotation' , $id_quotation);
            if($quotation->addProduct(Tools::getValue('id_product'), Tools::getValue('id_combination'), Tools::getValue('quantity')))
                echo 1;
            else
                echo 0;
        }
        else
            echo '-1';
    }

    public function displayAjaxGetProductInfo()
    {
        $context = Context::getContext();
        $id_lang = $context->language->id;
        $link = $this->context->link;
        $product = new Product(Tools::getValue('id_product'), false, $id_lang);

        $id_comination = Tools::getValue('id_combination');
        // die($id_comination);
        if (isset($id_comination) && !empty($id_comination)) {
            if (!empty($product->_getAttributeImageAssociations($id_comination))) {
                $image = $product->_getAttributeImageAssociations($id_comination);
                $image = $image[0];
            } else {
                $image = $product->getCover(Tools::getValue('id_product'));
                $image = $image['id_image'];
            }
        } else {
            $image = $product->getCover(Tools::getValue('id_product'));
            $image = $image['id_image'];
        }

        $product_image_link = $link->getImageLink($product->link_rewrite, $image, 'home_default');

        $product_name = explode(':', Product::getProductName(Tools::getValue('id_product'), $id_comination));
        $product_combination = $product_name[1];

        $result = array('product_combination' => $product_combination,
                        'product_image_link' => $product_image_link,
        );

        die(json_encode($result));
    }

    public function displayAjaxRemoveProduct()
    {
        if(!isset(Context::getContext()->cookie->id_quotation))
            return -1;

        require_once dirname(__FILE__).'/../QuotationFormController.class.php';
        $id_product = Tools::getValue('id_product');
        $id_combination = Tools::getValue('id_combination');
        $id_quotation = Context::getContext()->cookie->id_quotation;
        echo (int)QuotationFormController::removeProduct($id_quotation, $id_product, $id_combination);
    }

    public function displayAjaxRefreshCartDetails()
    {
        $quotation = new quotation;
        $result = $quotation->refreshCart();

        die($result);
    }

    public function displayAjaxAnswerForm()
    {
        if(!isset(Context::getContext()->cookie->id_quotation))
            return -1;

        require_once dirname(__FILE__).'/../QuotationFormController.class.php';
        $id_element = Tools::getValue('id_element');
        $value = Tools::getValue('val');
        $id_form = Tools::getValue('id_form');
        // $quotation = $_SESSION['id_quotation'];
        $quotation = Context::getContext()->cookie->id_quotation;
        echo (int)QuotationFormController::answerForm($quotation, $id_element, $value, $id_form);
    }

    public function displayAjaxUpdateStatut()
    {
        if(!isset(Context::getContext()->cookie->id_quotation))
            return -1;
        $statut = Tools::getValue('statut');
        require_once dirname(__FILE__).'/../../classes/QuotationObj.class.php';
        echo (int)QuotationObj::updateStatut(Context::getContext()->cookie->id_quotation, $statut);
    }

    public function displayAjaxCancelQuotation()
    {
        $id_quotation 	= Tools::getValue('id_quotation');
        $id_statut 		= Tools::getValue('id_statut');
        require_once dirname(__FILE__).'/../../classes/QuotationObj.class.php';
        echo QuotationObj::updateStatut($id_quotation, $id_statut, false);
    }

    public function displayAjaxUpdateIdForm()
    {
        if(!isset(Context::getContext()->cookie->id_quotation))
            echo -1;
        $id_form = Tools::getValue('id_form');
        require_once dirname(__FILE__).'/../QuotationFormController.class.php';
        if(QuotationFormController::updateIdForm(Context::getContext()->cookie->id_quotation, $id_form))
        {
            $query = 'SELECT email, id_lang FROM '._DB_PREFIX_.'customer WHERE id_customer = '.(int)Context::getContext()->cookie->id_customer;

            $to = Db::getInstance()->executeS($query);

            $template = 'new_quotation';
            $args = array();
            $args['{id_quot}'] = Configuration::get('QUOTATION_PREFIX').''.Context::getContext()->cookie->id_quotation;
            $args['{logo}'] =  _PS_BASE_URL_.__PS_BASE_URI__.'/img/'.Configuration::get('PS_LOGO', null, Context::getContext()->shop->id_shop_group, Context::getContext()->shop->id);
            $args['{customer_details}'] = Context::getContext()->cookie->customer_firstname.' '.Context::getContext()->cookie->customer_lastname.' (ID '.Context::getContext()->cookie->id_customer.')';
            $args['{quotation_ID}'] = Configuration::get('QUOTATION_PREFIX').Context::getContext()->cookie->id_quotation;
            $args['{shop_name}'] = Configuration::get('PS_SHOP_NAME', null, Shop::getContextShopGroupID(), Shop::getContextShopID());

            $quotation = Module::getInstanceByName('quotation');
            $quotation->sendMail($template, Configuration::get('PS_SHOP_EMAIL'), Configuration::get('PS_LANG_DEFAULT', null, Shop::getContextShopGroupID(), Shop::getContextShopID()), $args);

            $template = 'new_quotation_client';
            $args = array();
            $args['{customer_name}'] = Context::getContext()->cookie->customer_firstname.' '.Context::getContext()->cookie->customer_lastname;
            $args['{id_quot}'] = Configuration::get('QUOTATION_PREFIX').''.Context::getContext()->cookie->id_quotation;
            $args['{customerquotations_URL}'] =  _PS_BASE_URL_.__PS_BASE_URI__.'?fc=module&module=quotation&controller=customerquotations&id_quotation='.Context::getContext()->cookie->id_quotation;
            $args['{shop_name}'] =  Configuration::get('PS_SHOP_NAME', null, Shop::getContextShopGroupID(), Shop::getContextShopID());
            $args['{logo}'] =  _PS_BASE_URL_.__PS_BASE_URI__.'/img/'.Configuration::get('PS_LOGO', null, Context::getContext()->shop->id_shop_group, Context::getContext()->shop->id);
            $quotation->sendMail($template, $to[0]['email'], $to[0]['id_lang'], $args);
        }
        echo 1;
    }

    public function displayAjaxUnsetQuotation()
    {
        unset(Context::getContext()->cookie->id_quotation, Context::getContext()->cookie->products, Context::getContext()->cookie->total_cart, Context::getContext()->cookie->total_product);
    }
}
