/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*
* Don't forget to prefix your containers with your own identifier
* to avoid any conflicts with others containers.
*/
//
// for(var b in window) {
  // if(window.hasOwnProperty(b)) console.log(b);
// }
function quotation()
{
    hovering = false;

    $('.quotation_block').hover(function() {
        $('.quotation_inner_block').stop(true, true).slideDown(450);
        this.hovering = true;
    }, function() {
        setTimeout(function(){
            if (!this.hovering)
                $('.quotation_inner_block').stop(true, true).slideUp(450);
        }, 200);
        this.hovering = false;
    });
};

function answerForm(id_element, val)
{
    var answer = true;
    $.ajax({
        type: 'POST',
        url: ajax_url,
        dataType: 'html',
        data: {
            ajax : true,
            action : 'AnswerForm',
            id_element: id_element,
            val: val
        },
        async: false
    }).success(function(data){
        if(data != 1)
            answer = false;
    });
    return answer;
}

function quotationRemoveProduct(id_product, id_combination)
{
    $.ajax({
        type: 'POST',
        url: ajax_url,
        dataType: 'html',
        data: {
            action : 'RemoveProduct',
            ajax : true,
            id_product : id_product,
            id_combination : id_combination
        },
        async: false,

    }).success(function(data) {
        if(data == 1)
        {
            var price_before = parseFloat($('#quotation_block_total').html());
            var price_removed = parseFloat($('#price_'+id_product+'_'+id_combination).html());
            var price_final = price_before - price_removed;
            var quantity_before = $('#quotation_quantity').html();
            var quantity_removed = $('#quantity_'+id_product+'_'+id_combination).html();

            $('#quotation_quantity').html(quantity_before - quantity_removed);
            $('#quotation_block_total').html(price_final.toFixed(2));
            $('#quotation_block_product_'+id_product+'_'+id_combination).remove();

            $('#product_'+id_product+'_'+id_combination).remove();

            $('#total_product').html(quantity_before - quantity_removed);
            $.ajax({
                type: 'POST',
                url: ajax_url,
                dataType: 'html',
                data: {
                    action : 'RefreshCartDetails',
                    ajax : true,
                },
            }).success(function(data) {
                if (data !== '0.00') {
                    $('#total_amount_cart').html(data);
                } else {
                    $('#content').addClass('hidden');
                    $('#no_product').removeClass('hidden');
                }
            });
        }
    });
}

function handleQuotations()
{
    // Changement de statut
    $('.quotation-statut').change(function(){
        var id_quotation = $(this).data('quotation-id');
        var id_statut = $(this);
        $.ajax({
            type: 'POST',
            url: ajax_url,
            dataType: 'html',
            data: {
                action : 'SetStatut',
                ajax : true,
                id_quotation : id_quotation,
                id_statut : $(this).val()
            },
            async: false,

        }).success(function(data) {
            if(data == 1)
            {
                $('#quotation_statut_success').show('fast').delay(3000).hide('slow');
            }
        });
    });

    $('.quotation_details').click(function(){
        var id_quotation 	= $(this).data('quotation-id');
        var id_cart 		= $(this).data('cart-id');

        $.ajax({
            type: 'POST',
            url: quotation_url_customerQuotations,
            dataType: 'html',
            data: {
                action : 'GetQuotationDetails',
                ajax : true,
                id_quotation : id_quotation
            },
            // async: false,
        }).success(function(data) {
            $('#quotation_list').hide('slow');
            $('#quotation_details').toggleClass('hidden');
            $('#quotation_details_content').html(data);
            $('#quotation_messages').attr('quotation-id', id_quotation);
            $('#sendMessage').attr('quotation-id', id_quotation);
            $('#checkoutQuotation').attr('data-cart-id', id_cart);
            // CKEDITOR.replace('quotation-message');

            quotation_checkout();
            $.ajax({
                type: 'POST',
                url: quotation_url_customerQuotations,
                dataType: 'html',
                data: {
                    action : 'GetUnreadMessages',
                    ajax : true,
                    id_quotation : id_quotation,
                    employee : 0
                },
                async: false,
                }).success(function(data) {
                    $('#quotation_unread_messages').html(data);
                });
        });
    });

    $('#quotation_messages').click(function(){
        var id_quotation = $(this).attr('quotation-id');
        $.ajax({
            type: 'POST',
            url: quotation_url_customerQuotations,
            dataType: 'html',
            data: {
                action : 'GetMessages',
                ajax : true,
                id_quotation : id_quotation
            },
            async: false,
        }).success(function(data) {
            $('#quotation_details_content').hide();
            $('#messages_list').removeClass('hidden');
            $('#quotation_details_close').addClass('hidden');
            $('#quotation_details_back').removeClass('hidden');
            $('#messages_list_content').html(data);
            var ck = CKEDITOR.replace('quotation-message');

            ck.on('focus', function(){
                console.log(ck.getData());
                console.log('<p>'+message_default+'</p>');
                if(ck.document.getBody().getText() == message_default)
                    ck.setData('');
            });
            ck.on('blur', function(){
                if(ck.getData() == '')
                    ck.setData(message_default);
            });

            $.ajax({
                type: 'POST',
                url: quotation_url_customerQuotations,
                dataType: 'html',
                data: {
                    action : 'SetReadMessage',
                    ajax : true,
                    id_quotation : id_quotation,
                },
                async: false,
                }).success(function(data) {
                    $('#quotation_unread_messages').html(0);
                    $('#unread_'+id_quotation).html(0);
                });
        });
    });

    $('#quotation_details_back').click(function(){
        $('#messages_list').addClass('hidden');
        $('#quotation_details_close').removeClass('hidden');
        $(this).addClass('hidden');
        $('#quotation_details_content').show();
    });

    $('#sendMessage').click(function() {
        var id_quotation = $(this).attr('quotation-id');
        var ck = CKEDITOR.instances['quotation-message'];
        var message = ck.getData();
        $.ajax({
            type: 'POST',
            url: quotation_url_customerQuotations,
            dataType: 'html',
            data: {
                action : 'SendMessage',
                ajax : true,
                id_quotation : id_quotation,
                message : message
            },
            async: false,
        }).success(function(data) {
            if(data == 1){
                $.ajax({
                    type: 'POST',
                    url: quotation_url_customerQuotations,
                    dataType: 'html',
                    data: {
                        action : 'GetDateTime',
                        ajax : true,
                    },
                    async: false,
                }).success(function(data) {
                    ck.setData('');
                    var content = '<span class="infos">You - '+data+'</span><div class="large-9 small-12 quotation_messages_msg quotation_messages_msg-customer">'+message+'</div>';
                    $('#messages_list_content').append(content);
                });
            }
        });
    });

    $('#quotation_details_close').click(function(){
        $('#quotation_details').toggleClass('hidden');
        $('#quotation_list').show('fast');
        $('.quotation_action option[value="-"]').prop('selected', true);
    });
}

function modifyQuotation(id_quotation){
    $.ajax({
        type: 'POST',
        url: quotation_url_customerQuotations,
        dataType: 'html',
        data: {
            action : 'ModifyQuotation',
            ajax : true,
            id_quotation : id_quotation
        },
        async: false,
    }).success(function(data) {
        swal({title: "The quotation is loaded !",
        text: "you can now add product to it and send it again",
        type: "success",
        showCancelButton: false,
        confirmButtonColor: "#AEDEF4",
        confirmButtonText: "GO!",
        closeOnConfirm: true },
        function(){
            location.reload();
        });
    });
}
function quotation_checkout(){
    $('.quotation_checkout').click(function(){
        var id_cart = $(this).attr('data-cart-id');
        $.ajax({
            type: 'POST',
            url: quotation_url_customerQuotations,
            dataType: 'html',
            data: {
                ajax : true,
                action : 'SetCart',
                id_cart: id_cart,
            },
            async: false
        }).success(function(data){
            if(data == 1)
                window.location.assign(order_link);
            else
                sweetAlert(quotation_error, quotation_error_checkout, "error");
        });
    });
}
$(function() {
    quotation();
    handleQuotations();

    quotation_checkout();

    var modal = $('#modal_quotation');
    var modalOverlay = $('#modal_quot_overlay');
    var closeButton = $('.modal_quit');
    var openButton = $('#open_modal_quot');

    closeButton.click(function() {
        modal.toggleClass("closed");
        modalOverlay.toggleClass("closed");
        location.reload();
    });

    // openButton.click(function() {
    //     modal.toggleClass("closed");
    //     modalOverlay.toggleClass("closed");
    // });
    // $('a[rel*=leanModal]').leanModal({ top : 200, closeButton: ".modal_close" });
    // $("#call_modal").leanModal({ top : 200, overlay : 0.4, closeButton: ".modal_close" });

    $('.quotation_cancel').click(function() {
        id_quotation = $(this).attr('data-quotation-id');
        console.log(id_quotation);
        $.ajax({
            type: 'POST',
            url: ajax_url,
            // controller : quotation,
            dataType: 'html',
            data: {
                ajax : true,
                action : 'CancelQuotation',
                id_quotation: id_quotation,
                id_statut: 5
            },
        }).success(function(data){
            // swal('Good job!', 'You clicked the button!', 'success');
        });
    });

    $('.add_to_quotation').click(function() {
        if(!PS_CATALOG_MODE)
            var quantity = $('#quantity_wanted').val();
        else
            var quantity = $('#quotation_quantity_wanted').val();

        var id_product = $(this).attr('data-product-id');
        $(this).toggleClass('disabled');
        $.ajax({
            type: 'POST',
            url: ajax_url,
            dataType: 'html',
            data: {
                ajax : true,
                action : 'AddProduct',
                id_shop: id_shop,
                quantity: quantity,
                id_combination: $('#idCombination').val(),
                id_product: id_product
            },
        }).success(function(data){
            if(data == 1) {
                var isInIframe = (window.location != window.parent.location) ? true : false;
                if (isInIframe) {
                    window.parent.location.href = "index.php?fc=module&module=quotation&controller=quotation";
                } else {
                    $.ajax({
                        type: 'POST',
                        url: ajax_url,
                        dataType: 'html',
                        data: {
                            ajax : true,
                            action : 'GetProductInfo',
                            id_shop: id_shop,
                            quantity: quantity,
                            id_combination: $('#idCombination').val(),
                            id_product: id_product
                        },
                    }).success(function(data){
                        modal.toggleClass("closed");
                        modalOverlay.toggleClass("closed");

                        var tab = jQuery.parseJSON(data);

                        $('#modal_combination_name').html(tab.product_combination);
                        $('#modal_image').attr('src',tab.product_image_link);
                    });
                }
            } else {
                sweetAlert(quotation_error, 'quotation_error_add_product', "error");
            }
        });
        /*
        $.ajax({
            type: 'POST',
            url: ajax_path,
            dataType: 'html',
            data: {
                id_shop: id_shop,
                quotation_token: quotation_token,
                quantity: $('#quantity_wanted').val(),
                id_combination: $('#idCombination').val(),
                id_product: id_product,
                action: 'QUOTATION_addProductToQuotation'
            },
            async: false,
        })
        .success(function(data){
            if(data == 1){
                location.reload();
                // $.ajax({
                    // type: 'POST',
                    // url: ajax_path,
                    // dataType: 'html',
                    // data: {
                        // quotation_token: quotation_token,
                        // id_product: id_product,
                        // action: 'QUOTATION_getCover'
                    // },
                    // async: false,
                // })
                // .success(function(productCover) {
                    // console.log(productCover);
                // });
            }
        });*/
    });
    $('#sendQuotation').click(function(e){
        var result = true;
        $('#sendQuotation').addClass('hidden');
        $('#quotation_loader').removeClass('hidden');
        $('#quotation-front-form > li').each(function(i,j){
            var element = $(this).find('label');
            if(element.is('label'))
            {
                var string = element.attr('id');
                var temp = string.split('_');

                switch(temp[1])
                {
                    case 'text':
                        var id_element = $(this).find('input').attr('id');
                        var val = $(this).find('input').val();

                        if(!answerForm(id_element, val))
                            result = false;
                    break;
                    case 'textarea':
                        var id_element = $(this).find('textarea').attr('id');
                        var val = $(this).find('textarea').val();

                        if(!answerForm(id_element, val))
                            result = false;
                    break;
                    case 'checkboxgroup':
                        $(this).find('input[type=checkbox]').each(function(){
                            var id_element = $(this).attr('id');
                            if($(this).is(':checked'))
                                var val = 1;
                            else
                                var val = 0;

                            if(!answerForm(id_element, val))
                                result = false;
                        });
                    break;
                    case 'select':
                        $(this).find('option').each(function(){
                            var id_element = $(this).val();
                            if($(this).is(':selected'))
                                var val = 1;
                            else
                                var val = 0;

                            if(!answerForm(id_element, val))
                                result = false;
                        });
                    break;
                    case 'radiogroup':
                        $(this).find('input[type=radio]').each(function(){
                            var id_element = $(this).attr('id');
                            if($(this).is(':checked'))
                                var val = 1;
                            else
                                var val = 0;

                            if(!answerForm(id_element, val))
                                result = false;
                        });
                    break;
                }
            }
        });
        if(result)
        {
            var updateStatut = true;
            var updateIdForm = true;
            $.ajax({
                type: 'POST',
                url: ajax_url,
                dataType: 'html',
                data: {
                    ajax : true,
                    action : 'UpdateIdForm',
                    id_form : $('#id_form_quotation').val()
                },
                async: false
            }).success(function(data){
                if(data != 1)
                {
                    updateIdForm = false;
                }
                else
                {
                    $.ajax({
                        type: 'POST',
                        url: ajax_url,
                        dataType: 'html',
                        data: {
                            ajax : true,
                            action : 'UpdateStatut',
                            statut : '1',
                        },
                        async: false
                    }).success(function(data){
                        if(data != 1)
                            updateStatut = false;
                    });
                }
            });
            if(!updateIdForm)
            {
                $('#sendQuotation').removeClass('hidden');
                $('#quotation_loader').addClass('hidden');
                sweetAlert(quotation_error, quotation_error_update, "error");
            }
            if(!updateStatut)
            {
                $('#sendQuotation').removeClass('hidden');
                $('#quotation_loader').addClass('hidden');
                sweetAlert(quotation_error, quotation_error_update_statut, "error");
            }

            if(updateIdForm && updateStatut)
            {
                $.ajax({
                    type: 'POST',
                    url: ajax_url,
                    dataType: 'html',
                    data: {
                        ajax : true,
                        action : 'UnsetQuotation'
                    },
                    async: false
                }).success(function(data){
                    var url = quotation_url_customerQuotations+'&id_quotation='+$('#id_quotation').val();
                    $(location).attr('href',url);
                });
            }
        }
        else
        {
            $('#sendQuotation').removeClass('hidden');
            $('#quotation_loader').addClass('hidden');
            sweetAlert(quotation_error, quotation_error_save, "error");
        }
    });
});
