<?php
/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2014 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

$sql = array();

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."quot_form` (
  `id_form` int(11) NOT NULL AUTO_INCREMENT,
  `id_lang` int(11) NOT NULL,
  `form_name` varchar(250) NOT NULL,
  `active` int(11) NOT NULL,
  `id_shop` int(11) NOT NULL DEFAULT '0',
  `id_shop_group` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_form`,`id_lang`)
) ENGINE="._MYSQL_ENGINE_." AUTO_INCREMENT=1";

$sql[] = '
CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'quot_form_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_form` int(11) NOT NULL,
  `label` varchar(100) NOT NULL,
  `name` varchar(250) NOT NULL,
  `type_field` varchar(200) NOT NULL,
  `value` varchar(250) NOT NULL,
  `id_parent` int(11) NOT NULL,
  `pos` int(11) NOT NULL,
  `id_lang` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE='._MYSQL_ENGINE_.' AUTO_INCREMENT=1';

$sql[] = '
CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'quot_field_type` (
  `id_type` int(11) NOT NULL AUTO_INCREMENT,
  `name_type` varchar(250) NOT NULL,
  PRIMARY KEY (`id_type`)
) ENGINE='._MYSQL_ENGINE_.' AUTO_INCREMENT=1';

$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'quot_field_val` (
  `id_quot` int(11) NOT NULL,
  `id_form_field` int(11) NOT NULL,
  `value` varchar(9999) NOT NULL,
  PRIMARY KEY (`id_quot`,`id_form_field`)
) ENGINE='._MYSQL_ENGINE_.'';

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."quot` (
  `id_quot` int(11) NOT NULL AUTO_INCREMENT,
  `id_customer` int(11) DEFAULT NULL,
  `id_guest` int(11) DEFAULT NULL,
  `id_shop` int(11) NOT NULL DEFAULT '0',
  `id_shop_group` int(11) DEFAULT '0',
  `date` date NOT NULL,
  `id_statut` int(11) DEFAULT NULL,
  `id_form` int(11) DEFAULT NULL,
  `id_cart` int(11) NOT NULL DEFAULT '0',
  `id_cart_rule` int(11) NOT NULL DEFAULT '0',
  `id_currency` int(11) NULL,
  PRIMARY KEY (`id_quot`)
) ENGINE="._MYSQL_ENGINE_." AUTO_INCREMENT=500";

$sql[] = "
    REPLACE INTO `"._DB_PREFIX_."quot_field_type` (`id_type`, `name_type`) VALUES
    (1, 'checkbox'),
    (2, 'radio'),
    (3, 'select'),
    (4, 'input_text'),
    (5, 'textarea'),
    (6, 'static_text'),
    (7, 'hr')";

$sql[] = "ALTER TABLE  `"._DB_PREFIX_."quot_form_field` DROP PRIMARY KEY ,
ADD PRIMARY KEY (  `id` ,  `id_lang` )";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."quot_product` (
  `id_quot` int(11) NOT NULL,
  `id_product` int(11) NOT NULL,
  `id_combination` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `date_add` datetime NOT NULL,
  PRIMARY KEY (`id_quot`,`id_product`,`id_combination`)
) ENGINE="._MYSQL_ENGINE_."";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."quot_statut` (
  `id_statut` int(11) NOT NULL,
  `value` varchar(100) NOT NULL,
  `color` varchar(100) NOT NULL,
  `id_lang` varchar(5) NOT NULL,
  PRIMARY KEY (`id_statut`,`id_lang`)
) ENGINE="._MYSQL_ENGINE_."";

$sql[] = "ALTER TABLE  `"._DB_PREFIX_."quot_form_field` DROP PRIMARY KEY ,
ADD PRIMARY KEY (  `id` ,  `id_form` ,  `id_lang`)";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."quot_messages` (
  `id_message` int(11) NOT NULL AUTO_INCREMENT,
  `id_quot` int(11) NOT NULL,
  `id_employee` int(11) DEFAULT NULL,
  `date_add` datetime NOT NULL,
  `message` varchar(9999) NOT NULL,
  `is_read` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_message`)
) ENGINE='"._MYSQL_ENGINE_."' AUTO_INCREMENT=1";

$sql[] = "REPLACE INTO `"._DB_PREFIX_."quot_statut` (`id_statut`, `value`, `color`, `id_lang`) VALUES
(1, 'Validated by the client', '#FF8C00', 'en'),
(1, 'Validé par le client', '#FF8C00', 'fr'),
(2, 'En étude', '#4169E1', 'fr'),
(2, 'In study', '#4169E1', 'en'),
(3, 'Validated by the merchant', '#32CD32', 'en'),
(3, 'Validé par le marchand', '#32CD32', 'fr'),
(4, 'Rejected', '#DC143C', 'en'),
(4, 'Rejeté', '#DC143C', 'fr'),
(5, 'Cancelled', '#DC143C', 'en'),
(5, 'Annulé', '#DC143C', 'fr'),
(6, 'Ordered', '#FF69B4', 'en'),
(6, 'Commandé', '#FF69B4', 'fr')";

$sql[] = "REPLACE INTO `"._DB_PREFIX_."quot_statut` (`id_statut`, `value`, `color`, `id_lang`) VALUES ('7', 'En cours de modification', '#4169E1', 'fr'), ('7', 'Being modified', '#4169E1', 'en');";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."quot_group` (
          `id_group` int(11) NOT NULL,
          `active` int(11) NOT NULL,
          PRIMARY KEY (`id_group`)
        ) ENGINE='"._MYSQL_ENGINE_."'";

$return = true;
foreach ($sql as $query)
{
    if (Db::getInstance()->execute($query) == false)
        $return = false;
}

if($return)
{
    $groups = Group::getGroups($this->context->language->id, $this->context->shop->id);
    $return = true;
    foreach($groups as $group) {
        if(!Db::getInstance()->execute('REPLACE INTO '._DB_PREFIX_.'quot_group  VALUES ('.(int)$group['id_group'].', 1)'))
            $return = false;

    }
}
return $return;
