{*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*
* Don't forget to prefix your containers with your own identifier
* to avoid any conflicts with others containers.
*}
{literal}
<script>
    var quotation_delete_modal_title = "{/literal}{l s='Are you sure?' mod='quotation'}{literal}";
    var quotation_delete_modal_text = "{/literal}{l s='The quotation will be definitively deleted!' mod='quotation'}{literal}";
    ps_version = "{/literal}{$ps_version|intval}{literal}";
    multishop = "{/literal}{$multishop|intval}{literal}";
    debug_mode = "{/literal}{$debug_mode|intval}{literal}";
    current_id_tab = "{/literal}{$current_id_tab|intval}{literal}";
    admin_module_ajax_url = "{/literal}{$controller_url}{literal}";
    admin_module_controller = "{/literal}{$controller_name|escape:'htmlall':'UTF-8'}{literal}";
    nb_quotation = "{/literal}{$nb_quotation|intval}{literal}";
    deleteConfirmation = "{/literal}{l s='Yes, delete it!' mod='quotation'}{literal}"
    var quotation_translations = new Array();
    quotation_translations['fill_all_languages'] = "{/literal}{l s='Please fill all languages' mod='quotation'}{literal}";
    quotation_translations['no'] = "{/literal}{l s='No' mod='quotation'}{literal}";
    quotation_translations['yes'] = "{/literal}{l s='Yes' mod='quotation'}{literal}";
    quotation_translations['choice'] = "{/literal}{l s='Choice' mod='quotation'}{literal}";
    quotation_translations['messages_list'] = "{/literal}{l s='Message list' mod='quotation'}{literal}";
    quotation_translations['send_message'] = "{/literal}{l s='Send a message' mod='quotation'}{literal}";
    quotation_translations['message_default']  = "{/literal}{l s='Enter your text below in order to send a message to the customer...' mod='quotation'}{literal}";
    quotation_translations['error_form_save']  = "{/literal}{l s='Error while saving the form...' mod='quotation'}{literal}";
    quotation_translations['checkbox']  = "{/literal}{l s='Checkbox' mod='quotation'}{literal}";
{/literal}
    var languages = new Array();
    {foreach from=$languages item=language}
        languages[languages.length] = {$language.id_lang|escape:'htmlall':'UTF-8'};
    {/foreach}
    var languages_iso = new Array();
    {foreach from=$languages item=language}
        languages_iso[languages_iso.length] = "{$language.iso_code|escape:'htmlall':'UTF-8'}";
    {/foreach}
    var default_language = {$lang_default|escape:'htmlall':'UTF-8'};
    next_message = "{l s=' Next' mod='quotation' js=1}";
</script>
{if $ps_version == 0}
<div class="bootstrap">
    <!-- Beautiful header -->
    {include file="./header.tpl"}
{/if}
    <!-- Module content -->
    <div id="modulecontent" class="clearfix">
        <!-- Nav tabs -->
        <div class="col-lg-2">
            <div class="list-group">
                <a href="#documentation" data-tab="documentation" class="list-group-item {if $tab eq 'doc'}active{/if}" data-toggle="tab" selected_menu><i class="icon-book"></i> {l s='Documentation' mod='quotation'}</a>

                <a href="#conf" data-tab="conf" class="list-group-item {if $tab eq 'conf'}active{/if} selected_menu" data-toggle="tab"><i class="icon-cogs"></i> {l s='Configuration' mod='quotation'}</a>
                <a href="#forms" data-tab="forms" class="list-group-item {if $tab eq 'forms'}active{/if} selected_menu" data-toggle="tab"><i class="icon-cogs"></i> {l s='Quotations forms' mod='quotation'}</a>
                <a href="#quotations" data-tab="quotations" class="list-group-item {if $tab eq 'quotations'}active{/if} selected_menu" data-toggle="tab"><i class="icon-cogs"></i> {l s='Quotations' mod='quotation'}</a>
                <a href="#help" data-tab="help" class="list-group-item {if $tab eq 'help'}active{/if} selected_menu" data-toggle="tab"><i class="icon-question-circle"></i> {l s='Help' mod='quotation'}</a>
                <a href="#contacts" data-tab="contacts" class="contacts list-group-item selected_menu" data-toggle="tab"><i class="icon-envelope"></i> {l s='Contact' mod='quotation'}</a>
            </div>
            <div class="list-group">
                <a class="list-group-item"><i class="icon-info"></i> {l s='Version' mod='quotation'} {$module_version|escape:'htmlall':'UTF-8'}</a>
            </div>
        </div>
        <!-- Tab panes -->
        <div class="tab-content col-lg-10">
            <div class="tab-pane {if $tab eq 'doc'}active{/if} panel" id="documentation">
                {include file="./tabs/documentation.tpl"}
            </div>
            <div class="tab-pane {if $tab eq 'conf'}active{/if} panel" id="conf">
                {include file="./tabs/conf.tpl"}
            </div>
            <div class="tab-pane {if $tab eq 'forms'}active{/if} panel" id="forms">
                {include file="./tabs/quotations_list.tpl"}
            </div>
            <div class="tab-pane {if $tab eq 'quotations'}active{/if} panel" id="quotations">
                {include file="./tabs/quotations.tpl"}
            </div>
            <div class="tab-pane {if $tab eq 'help'}active{/if} panel" id="help">
                {include file="./tabs/help.tpl"}
            </div>
            <div class="tab-pane panel" id="contacts">
                {include file="./tabs/contact.tpl"}
            </div>
        </div>
    </div>
{if $ps_version == 0}
    <!-- Manage translations -->
    {include file="./translations.tpl"}
</div>
{/if}
