{*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*
* Don't forget to prefix your containers with your own identifier
* to avoid any conflicts with others containers.
*}
<form name="conf" id="conf" action="#" method="POST" class="form-inline" role="form">
    <h3><i class="icon-book"></i> {l s='Configruration' mod='quotation'} <small>{$module_display|escape:'htmlall':'UTF-8'}</small></h3>
    <div class="row">
        <div id="quotation_config_success" class="alert alert-success" role="alert" {if !isset($tab) || $tab != 'conf'}style="display: none;"{/if}>{l s='Config success' mod='quotation'}</div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="alert alert-info">
                {l s='Test mode gives you a preview of the quote in the store, which is only viewable from your computer. To use it, click on the "Add my IP" button and enable test mode.' mod='quotation'}
                <br><br>
                {l s='When you want to make the quote-request function available to all your customers, disable test mode, and the quote form will be displayed on your store.' mod='quotation'}
            </div>
        </div>
        <div class="form-group col-lg-12">
            <label class="control-label col-lg-1">
                {l s='Test mode' mod='quotation'}
            </label>
            <div class="col-lg-2">
                <span class="switch prestashop-switch fixed-width-lg">
                    <input type="radio" name="active" id="active_on" value="1" {if $quotation_live_mode eq 0}checked="checked"{/if}>
                    <label for="active_on" class="test_mode" val="0">
                        {l s='Test mode' mod='quotation'}
                    </label>
                    <input type="radio" name="active" id="active_off" value="0" {if $quotation_live_mode eq 1}checked="checked"{/if}>
                    <label for="active_off" class="test_mode" val="1">
                        {l s='Live' mod='quotation'}
                    </label>
                    <a class="slide-button btn"></a>
                </span>
            </div>
            <div id="live_mode_ip" {if $quotation_live_mode eq 1}style="display:none;"{/if}>
                <div class="col-lg-1"><span class="pull-left">
                </span></div>
                <label class="control-label col-lg-2">
                    {l s='IP adress for test mode' mod='quotation'}
                </label>
                <div class="col-lg-2">
                    <div class="input-group">
                        <input name="ipAdress" id="ipAdress" type="text" value="{$quotation_ip|escape:'htmlall':'UTF-8'}">
                        <span class="input-group-addon"><button id="addIpAdress">{l s='Add my IP' mod='quotation'}</button></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <br><br>
    <div class="row">
        <div class="col-lg-12">
            <div class="alert alert-info">
                {l s='Add a prefix to the reference number for each quote, e.g.: 2015-JANUARY-' mod='quotation'}
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-lg-5">
                {l s='Quotation prefix' mod='quotation'}
            </label>
            <div class="col-lg-5">
                <div class="input-group">
                    <input name="quotationPrefix" id="quotationPrefix" type="text" value="{$quotation_prefix|escape:'htmlall':'UTF-8'}">
                </div>
            </div>
        </div>
    </div>
    <br>
    <div class="row">
        <h3>{l s='Groups authorization' mod='quotation'}</h3>
        <table class="table table-stripped">
            <thead>
                <tr><td>{l s='Group name' mod='quotation'}</td><td>{l s='Status' mod='quotation'}</td></tr>
            </thead>
            <tbody>
                {foreach from=$groups item=group}
                    <tr>
                        <td>{$group.name}</td>
                        <td>
                            <a class="list-action-enable {if $group.active eq 1}action-enabled{else}action-disabled{/if} switchs cursor_pointer">
                                <i class="icon-check {if $group.active eq 0}hidden{/if}" style="cursor:pointer"></i>
                                <i class="icon-remove {if $group.active eq 1}hidden{/if}" style="cursor:pointer"></i>
                            </a>
                            <input type="hidden" name="groups[{$group.id_group}]" class="active" value="{$group.active}">
                        </td>
                    </tr>
                {/foreach}
            </tbody>
        </table>
    </div>
    <input type="hidden" name="submit">
    <input type="hidden" name="submit_conf" value="1">
    <input type="hidden" name="quotation_tab" value="conf">
    <div class="panel-footer">
        <button type="submit" id="saveConf" class="btn btn-default pull-right"><i class="process-icon-save"></i> {l s='Save' mod='quotation'}</button>
    </div>
</form>
