{*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*
* Don't forget to prefix your containers with your own identifier
* to avoid any conflicts with others containers.
*}

<h3><i class="icon-book"></i> {l s='Quotations' mod='quotation'} <small>{$module_display|escape:'htmlall':'UTF-8'}</small></h3>
<div class="row">
    <div id="quotation_statut_success" class="alert alert-success" role="alert" style="display: none;">{l s='Quotation statut modified' mod='quotation'}</div>
</div>
<div id="quotation_list" class="row" class="display">
    <div class="table-responsive">
        <table id="quotation_list_table" class="display table table-striped table-bordered table-hover">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>{l s='Form name' mod='quotation'}</th>
                    <th>{l s='Client' mod='quotation'}</th>
                    <th>{l s='Status' mod='quotation'}</th>
                    <th>{l s='Articles number' mod='quotation'}</th>
                    <th>{l s='Unread messages' mod='quotation'}</th>
                    <th>{l s='Actions' mod='quotation'}</th>
                </tr>
            </thead>
            <tbody>
                {foreach from=$quotations item=quotation}
                    <tr id="quotation_id_{$quotation.id_quot|escape:'htmlall':'UTF-8'}">
                        <td>{$quotation_prefix|escape:'htmlall':'UTF-8'}{$quotation.id_quot|escape:'htmlall':'UTF-8'}</td>
                        <td>{$quotation.form_name|escape:'htmlall':'UTF-8'}</td>
                        <td>{$quotation.firstname|escape:'htmlall':'UTF-8'} {$quotation.lastname|escape:'htmlall':'UTF-8'}</td>
                        <td>
                            {if $quotation.id_statut neq 6}
                            <select id="quotation-statut-{$quotation.id_quot|escape:'htmlall':'UTF-8'}" class="quotation-statut" data-quotation-id="{$quotation.id_quot|escape:'htmlall':'UTF-8'}">
                            {foreach from=$statuts item=statut}
                                <option value="{$statut.id_statut|escape:'htmlall':'UTF-8'}"
                                {if $statut.id_statut eq $quotation.id_statut}
                                selected="selected"
                                {/if}>
                                    {$statut.value|escape:'htmlall':'UTF-8'}
                                </option>
                            {/foreach}
                            </select>
                            {else}
                                {$statuts.5.value|escape:'htmlall':'UTF-8'}
                            {/if}
                        </td>
                        <td>{$quotation.real_quantity|escape:'htmlall':'UTF-8'}</td>
                        <td id="unread_{$quotation.id_quot}">{$quotation.unread|escape:'htmlall':'UTF-8'}</td>
                        <td>
                            <a class="quotation-details quotation_action btn btn-default" value="details" data-quotation-id="{$quotation.id_quot|escape:'htmlall':'UTF-8'}">{l s='Details' mod='quotation'}</a>
                            <a class="quotation-delete btn btn-danger" data-quotation-id="{$quotation.id_quot|escape:'htmlall':'UTF-8'}"><i class="icon-trash"></i></a>
                            {* <select class="quotation_action" data-quotation-id="{$quotation.id_quot|escape:'htmlall':'UTF-8'}">
                                <option value="-">-</option>
                                <option value="details" class="quotation-details">{l s='Details' mod='quotation'}</option>
                                <!--<option value="delete" class="quotation-delete">{l s='Delete' mod='quotation'}</option>-->
                            </select> *}
                        </td>
                    </tr>
                {/foreach}
            </tbody>
        </table>
    </div>
</div>
<div id="quotation_details" class="row hidden">
    <div>
        <a id="quotation_details_close" class="btn btn-default">{l s='Back to quotation list' mod='quotation'}</a>
        <a id="quotation_messages" quotation-id="" class="btn btn-default pull-right" data-toggle="modal" data-target="#messagesModal">{l s='Send/View messages' mod='quotation'} (<span id="unread_messages">0</span>)</a>
    </div>
    <div id="quotation_details_content">

    </div>
    <!-- MESSAGES MODAL -->
    {include file='./modals/messages.tpl'}
</div>
