{*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*
* Don't forget to prefix your containers with your own identifier
* to avoid any conflicts with others containers.
*}
<script>
    var quotation_are_you_sure = "{l s='Are you sure?' mod='quotation'}";
    var quotation_are_you_sure_two = "{l s='All the other forms will be deactivated' mod='quotation'}";
    var quotation_yes = "{l s='Yes' mod='quotation'}";
    var quotation_cancel = "{l s='Cancel' mod='quotation'}";
    var quotation_deactivated = "{l s='Deactivated!' mod='quotation'}";
    var quotation_deactivated2 = "{l s='Your form has been deactivated' mod='quotation'}";
    var quotation_activated = "{l s='Activated!' mod='quotation'}";
    var quotation_activated2 = "{l s='Your form has been activated' mod='quotation'}";
    var quotation_success = "{l s='success' mod='quotation'}";
    var cart_created = "{l s='Cart and discount created !' mod='quotation'}";
    var cart_created2 = "{l s='Your client has received an notification by email.' mod='quotation'}";

    var quotation_activate_warning = "{l s='Warning!' mod='quotation'}";
    var quotation_activate_warning2 = "{l s='By activating this form, all the others forms will be deactivate.' mod='quotation'}";
</script>
<h3>
    <i class="icon-book"></i> {l s='Create and edit your quotation forms' mod='quotation'}
</h3>
<div class="row">
    {l s='Welcome to the configuration panel for a quote form!' mod='quotation'}
    <br>
    {l s='Here you can create your own form that is adapted to your business. Click on "New Form" to begin. You\'ll then see the list of forms that you have created with this module.' mod='quotation'}
</div>
<hr>
<div class="row">
    <center><button id="newQuotation" type="button" class="btn btn-default"><i class="process-icon-new"></i> {l s='New quotation' mod='quotation'}</button></center>
</div>
<div id="quotation_editor"class="row">
    <div>
        <button id="closeForm" type="button" class="btn btn-default pull-right"><i class="icon-remove"></i></button>
        <h3>
            {l s='Select a language' mod='quotation'}
        </h3>
    {if $lang_count > 1}
        {foreach from=$languages item=language}
            <button type="button" toggle="input_select_{$language.id_lang|escape:'htmlall':'UTF-8'}_container" toggle_lang="{$language.id_lang|escape:'htmlall':'UTF-8'}" class="lang_toggle_{$language.id_lang|escape:'htmlall':'UTF-8'} lang_toggle btn {if $language.id_lang neq $lang_default}btn-default{else} btn-primary{/if}">{$language.iso_code|escape:'htmlall':'UTF-8'}</button>
        {/foreach}
    {/if}
    </div>
    <br>
    <form id="quotation_form" action="#" method="POST">
        <div>
            <h3>
                {l s='Quotation name' mod='quotation'}
            </h3>
            <div class="row">
                <div class="col-lg-12">
                    <div class="alert alert-info">
                        {l s='Enter the name of your quotation in each languages activated for your shop.' mod='quotation'}
                    </div>
                </div>
            </div>
            {foreach from=$languages item=language}
                <div id="form_{$language.id_lang|escape:'htmlall':'UTF-8'}_container" class="{if $language.id_lang neq $lang_default} hidden{/if} multilang {$language.id_lang|escape:'htmlall':'UTF-8'}_container form_container" style="width:20%">
                    <input type="text" name="quotation_name_{$language.id_lang|escape:'htmlall':'UTF-8'}" id="quotation_name_{$language.id_lang|escape:'htmlall':'UTF-8'}" class="quotation_name" id_lang="{$language.id_lang|escape:'htmlall':'UTF-8'}">
                </div>
            {/foreach}
        </div>
        <br>
        <div class="row">
            <h3>{l s='Add items to your form' mod='quotation'}</h3>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="alert alert-info">
                    {l s='Select the items you want to display on your quotation form and translate them to every languages.' mod='quotation'}
                </div>
            </div>
        </div>
        <div class="row">
            <center>
                <span>
                    <a value="static_text" class="btn btn-default addable" data-toggle="modal" data-target="#staticTextModal">{l s='Static text' mod='quotation'}</a>
                    <a value="text" class="btn btn-default addable" data-toggle="modal" data-target="#textModal">{l s='Text input' mod='quotation'}</a>
                    <a value="textarea" class="btn btn-default addable" data-toggle="modal" data-target="#textareaModal">{l s='Text area' mod='quotation'}</a>
                    <a value="checkbox" class="btn btn-default addable" data-toggle="modal" data-target="#checkboxModal">{l s='Checkbox' mod='quotation'}</a>
                    <a value="radio" class="btn btn-default addable" data-toggle="modal" data-target="#radioModal">{l s='Radio button' mod='quotation'}</a>
                    <a value="select" class="btn btn-default addable" data-toggle="modal" data-target="#selectModal">{l s='Select menu' mod='quotation'}</a>
                    <a id="addLine" value="button" class="btn btn-default addable">{l s='Divider' mod='quotation'}</a>
                </span>
            </center>
        </div>
        {foreach from=$languages item=language}
            <ul id="form_{$language.id_lang|escape:'htmlall':'UTF-8'}" class="col-xs-12 form {$language.id_lang|escape:'htmlall':'UTF-8'}_container multilang">
            </ul>
        {/foreach}
        <input type="hidden" id="id_quotation" name="id_quotation" value="{$nb_quotation+1|escape:'htmlall':'UTF-8'}">
        <input type="hidden" id="activate_quotation" name="activate_quotation" value="0">
        <input type="hidden" name="saveQuotation" value="1">
    </form>
    <hr>
    <button id="saveForm" type="button" class="btn btn-default pull-right"><i class="process-icon-save"></i> {l s='Save quotation' mod='quotation'}</button>
</div>
<br><br>
<h3><i class="icon-book"></i> {l s='Quotations list' mod='quotation'} <small>{$module_display|escape:'htmlall':'UTF-8'}</small></h3>
{if empty($formActive)}
    <div id="warningNoneQuot" class="alert alert-warning">{l s='Warning ! You have no active forms, nothing wil be displayed on the front office. Please active one form at least.' mod='quotation'}</div>
{else}
    <div id="warningNoneQuot" class="alert alert-warning hidden">{l s='Warning ! You have no active forms, nothing wil be displayed on the front office. Please active one form at least.' mod='quotation'}</div>
{/if}
<div class="row">
    <div class="form-group clear">
        <table class="table tabled-stripped">
            <thead>
                <tr>
                    <th>{l s='ID' mod='quotation'}</th>
                    <th>{l s='Name' mod='quotation'}</th>
                    <th>{l s='State' mod='quotation'}</th>
                    <th>{l s='Actions' mod='quotation'}</th>
                </tr>
            </thead>
            <tbody>
                {foreach from=$forms item=form}
                <tr>
                    <td>{$form.id_form|escape:'htmlall':'UTF-8'}</td>
                    <td>{$form.form_name|escape:'htmlall':'UTF-8'}</td>
                    <td id="{$form.id_form|escape:'htmlall':'UTF-8'}_activated" class="quot_activated">
                        <a data-quotation="{$form.id_form|escape:'htmlall':'UTF-8'}" data-activated="{$form.active|escape:'htmlall':'UTF-8'}" class="list-action-enable quotation_form_activate {if $form.active eq 1}action-enabled{else}action-disabled{/if}">
                            <i class="icon-check {if $form.active eq 0}hidden{/if}" style="cursor:pointer"></i>
                            <i class="icon-remove {if $form.active eq 1}hidden{/if}" style="cursor:pointer"></i>
                        </a>
                    </td>
                    <td>
                        <a class="edit_quotation btn btn-default" data-quotation="{$form.id_form|escape:'htmlall':'UTF-8'}"><i class="icon-pencil icon-2"></i></a>
                        {* <a class="delete_quotation_form btn btn-danger" data-quotation="{$form.id_form|escape:'htmlall':'UTF-8'}"><i class="icon-trash"></i></a> *}
                    </td>
                </tr>
                {/foreach}
            </tbody>
        </table>
    </div>
</div>

<!-- STATIC TEXT MODAL -->
{include file='./modals/static_text.tpl'}

<!-- TEXT MODAL -->
{include file='./modals/input_text.tpl'}

<!--TEXT AREA MODAL -->
{include file='./modals/input_textarea.tpl'}

<!-- CHECKBOX MODAL -->
{include file='./modals/checkbox.tpl'}

<!-- RADIO MODAL -->
{include file='./modals/radio.tpl'}

<!-- SELECT MODAL -->
{include file='./modals/select.tpl'}

<!-- EDIT MODAL -->
{include file='./modals/edit.tpl'}
