<?php
/**
* 2007-2018 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2018 PrestaShop SA
*  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class StoresController extends FrontController
{
	public $php_self = 'stores';
	public function init()
	{
		parent::init();
		if (!extension_loaded('Dom')) {
			$this->errors[] = Tools::displayError('PHP "Dom" extension has not been loaded.');
			$this->context->smarty->assign('errors', $this->errors);
		}
	}

	protected function processStoreAddress($store)
	{
		$ignore_field = array(
			'firstname',
			'lastname'
		);

		$out_datas = array();

		$address_datas = AddressFormat::getOrderedAddressFields($store['id_country'], false, true);
		$state = (isset($store['id_state'])) ? new State($store['id_state']) : null;

		foreach ($address_datas as $data_line) {
			$data_fields = explode(' ', $data_line);
			$addr_out = array();

			$data_fields_mod = false;
			foreach ($data_fields as $field_item) {
				$field_item = trim($field_item);
				if (!in_array($field_item, $ignore_field) && !empty($store[$field_item])) {
					$addr_out[] = ($field_item == 'city' && $state && isset($state->iso_code) && Tools::strlen($state->iso_code)) ?
						$store[$field_item].', '.$state->iso_code : $store[$field_item];
					$data_fields_mod = true;
				}
			}
			if ($data_fields_mod) {
				$out_datas[] = implode(' ', $addr_out);
			}
		}

		$out = implode('<br />', $out_datas);
		return $out;
	}


	protected function assignStoresSimplified()
	{
		$stores = Db::getInstance()->executeS('
		SELECT s.*, cl.name country, st.iso_code state
		FROM '._DB_PREFIX_.'store s
		'.Shop::addSqlAssociation('store', 's').'
		LEFT JOIN '._DB_PREFIX_.'country_lang cl ON (cl.id_country = s.id_country)
		LEFT JOIN '._DB_PREFIX_.'state st ON (st.id_state = s.id_state)
		WHERE s.active = 1 AND cl.id_lang = '.(int)$this->context->language->id);

		foreach ($stores as &$store) {
			$store['has_picture'] = file_exists(_PS_STORE_IMG_DIR_.(int)($store['id_store']).'.jpg');
			if ($working_hours = $this->renderStoreWorkingHours($store)) {
				$store['working_hours'] = $working_hours;
			}
		}

		$this->context->smarty->assign(array(
			'simplifiedStoresDiplay' => true,
			'stores' => $stores
		));
	}

	public function renderStoreWorkingHours($store)
	{
		$days = array();
		$days[1] = 'Monday';
		$days[2] = 'Tuesday';
		$days[3] = 'Wednesday';
		$days[4] = 'Thursday';
		$days[5] = 'Friday';
		$days[6] = 'Saturday';
		$days[7] = 'Sunday';
		$days_datas = array();
		$hours = array();
		if ($store['hours'] && Tools::version_compare(_PS_VERSION_, '1.7.0.0', '<') == true) {
			$hours = Tools::unSerialize($store['hours']);
			if (is_array($hours)) {
				$hours = array_filter($hours);
			}
		}
		elseif ($store['hours'] && Tools::version_compare(_PS_VERSION_, '1.7.0.0', '>=') == true) {
			$hours = $store['hours'];
			$hours = preg_replace('~[\\]\[\/*?"<>|]~', '', $hours);
			$hours = explode(',', $hours);
			if (is_array($hours)) {
				$hours = array_filter($hours);
			}
		}
		if (!empty($hours)) {
			for ($i = 1; $i < 8; $i++) {
				if (isset($hours[(int)$i - 1])) {
					$hours_datas = array();
					$hours_datas['hours'] = $hours[(int)$i - 1];
					$hours_datas['day'] = $days[$i];
					$days_datas[] = $hours_datas;
				}
			}
			$version_check = (Tools::version_compare(_PS_VERSION_, '1.7.0.0', '>=') == true) ? 1 : 0;
			$this->context->smarty->assign('days_datas', $days_datas);
			$this->context->smarty->assign('id_country', $store['id_country']);
			$this->context->smarty->assign('ver_ps', (int)$version_check);
			return $this->context->smarty->fetch(_PS_MODULE_DIR_.'storelocator/views/templates/front/store_infos.tpl');
		}
		return false;
	}

	public function getStores()
	{
		$distanceUnit = Configuration::get('PS_DISTANCE_UNIT');
		if (!in_array($distanceUnit, array('km', 'mi'))) {
			$distanceUnit = 'km';
		}

		if (Tools::getValue('all') == 1) {
			$stores = Db::getInstance()->executeS('
			SELECT s.*, cl.name country, st.iso_code state
			FROM '._DB_PREFIX_.'store s
			'.Shop::addSqlAssociation('store', 's').'
			LEFT JOIN '._DB_PREFIX_.'country_lang cl ON (cl.id_country = s.id_country)
			LEFT JOIN '._DB_PREFIX_.'state st ON (st.id_state = s.id_state)
			WHERE s.active = 1 AND cl.id_lang = '.(int)$this->context->language->id);
		}
		else {
			$distance = (int)(Tools::getValue('radius', 100));
			$multiplicator = ($distanceUnit == 'km' ? 6371 : 3959);
			$stores = Db::getInstance()->executeS('
			SELECT s.*, cl.name country, st.iso_code state,
			('.(int)($multiplicator).'
				* acos(
					cos(radians('.(float)(Tools::getValue('latitude')).'))
					* cos(radians(latitude))
					* cos(radians(longitude) - radians('.(float)(Tools::getValue('longitude')).'))
					+ sin(radians('.(float)(Tools::getValue('latitude')).'))
					* sin(radians(latitude))
				)
			) distance,
			cl.id_country id_country
			FROM '._DB_PREFIX_.'store s
			'.Shop::addSqlAssociation('store', 's').'
			LEFT JOIN '._DB_PREFIX_.'country_lang cl ON (cl.id_country = s.id_country)
			LEFT JOIN '._DB_PREFIX_.'state st ON (st.id_state = s.id_state)
			WHERE s.active = 1 AND cl.id_lang = '.(int)$this->context->language->id.'
			HAVING distance < '.(int)($distance).'
			ORDER BY distance ASC
			LIMIT 0,20');
		}
		return $stores;
	}

	protected function assignStores()
	{
		$this->context->smarty->assign('hasStoreIcon', file_exists(_PS_IMG_DIR_.Configuration::get('PS_STORES_ICON')));

		$distanceUnit = Configuration::get('PS_DISTANCE_UNIT');
		if (!in_array($distanceUnit, array('km', 'mi'))) {
			$distanceUnit = 'km';
		}

		$this->context->smarty->assign(array(
			'distance_unit' => $distanceUnit,
			'simplifiedStoresDiplay' => false,
			'stores' => $this->getStores(),
			'FMESL_LAYOUT' => (int)Configuration::get('FMESL_LAYOUT'),
		));
	}

	protected function displayAjax()
	{
		$days = array();
		$product = Tools::getValue('product'); 
		$stores = $this->getStores();
		$dom = new DOMDocument('1.0');
		$node = $dom->createElement('markers');
		$parnode = $dom->appendChild($node);

		$days[1] = 'Monday';
		$days[2] = 'Tuesday';
		$days[3] = 'Wednesday';
		$days[4] = 'Thursday';
		$days[5] = 'Friday';
		$days[6] = 'Saturday';
		$days[7] = 'Sunday';

		foreach ($stores as $store) {
			$related_products = $store['related_products'];
			$related_products = explode(',', $related_products);
			//print_r($related_products); exit; 
			if (!empty($product) && in_array($product, $related_products)) {
				$other = '';
				$node = $dom->createElement('marker');
				$newnode = $parnode->appendChild($node);
				$newnode->setAttribute('name', $store['name']);
				$address = $this->processStoreAddress($store);

				$other .= $this->renderStoreWorkingHours($store);
				$newnode->setAttribute('addressNoHtml', strip_tags(str_replace('<br />', ' ', $address)));
				$newnode->setAttribute('address', $address);
				$newnode->setAttribute('other', $other);
				$newnode->setAttribute('phone', $store['phone']);
				$newnode->setAttribute('id_store', (int)($store['id_store']));
				$newnode->setAttribute('has_store_picture', file_exists(_PS_STORE_IMG_DIR_.(int)($store['id_store']).'.jpg'));
				$newnode->setAttribute('lat', (float)($store['latitude']));
				$newnode->setAttribute('lng', (float)($store['longitude']));
				if (isset($store['distance']))
					$newnode->setAttribute('distance', (int)($store['distance']));
			}
			elseif (empty($product)) {
				$other = '';
				$node = $dom->createElement('marker');
				$newnode = $parnode->appendChild($node);
				$newnode->setAttribute('name', $store['name']);
				$address = $this->processStoreAddress($store);

				$other .= $this->renderStoreWorkingHours($store);
				$newnode->setAttribute('addressNoHtml', strip_tags(str_replace('<br />', ' ', $address)));
				$newnode->setAttribute('address', $address);
				$newnode->setAttribute('other', $other);
				$newnode->setAttribute('phone', $store['phone']);
				$newnode->setAttribute('id_store', (int)($store['id_store']));
				$newnode->setAttribute('has_store_picture', file_exists(_PS_STORE_IMG_DIR_.(int)($store['id_store']).'.jpg'));
				$newnode->setAttribute('lat', (float)($store['latitude']));
				$newnode->setAttribute('lng', (float)($store['longitude']));
				if (isset($store['distance'])) {
					$newnode->setAttribute('distance', (int)($store['distance']));
				}
				
			}
		}

		header('Content-type: text/xml');
		die($dom->saveXML());
	}

	public function initContent()
	{
		parent::initContent();
		if (Configuration::get('PS_STORES_SIMPLIFIED')) {
			$this->assignStoresSimplified();
		}
		else {
			$this->assignStores();
		}
		if (Tools::version_compare(_PS_VERSION_, '1.7.0.0', '>=') == true) {
			$medium_size = Image::getSize(ImageType::getFormattedName('medium'));
		}
		else {
			$medium_size = Image::getSize(ImageType::getFormatedName('medium'));
		}
		$def_zoom = (int)Configuration::get('FMESL_ZOOM_VALUE');
		$def_zoom = ($def_zoom <= 0) ? 10 : $def_zoom;
		$lang_id = (int)$this->context->language->id;
		$this->context->smarty->assign(array(
				'mediumSize' => $medium_size,
				'defaultLat' => (float)Configuration::get('PS_STORES_CENTER_LAT'),
				'defaultLong' => (float)Configuration::get('PS_STORES_CENTER_LONG'),
				'searchUrl' => $this->context->link->getPageLink('stores'),
				'logo_store' => Configuration::get('PS_STORES_ICON'),
				'stores' => $this->getAllStores(),
				'FMESL_USER' => (int)Configuration::get('FMESL_USER'),
				'FMESL_RESET' => (int)Configuration::get('FMESL_RESET'),
				'FMESL_SBP' => (int)Configuration::get('FMESL_SBP'),
				'fmm_sl_zoom' => (int)$def_zoom,
				'fmm_sl_pageheading' => Configuration::get('FMESL_PAGE_TITLE', $lang_id),
		));

		if (Tools::version_compare(_PS_VERSION_, '1.7.0.0', '>=') == true) {
			$protocol_link = (Configuration::get('PS_SSL_ENABLED') || Tools::usingSecureMode()) ? 'https://' : 'http://';
			$api_key = Configuration::get('FMESL_KEY');
			$_http = (Configuration::get('PS_SSL_ENABLED') && Configuration::get('PS_SSL_ENABLED_EVERYWHERE')) ? 'https' : 'http';
			$default_country = new Country((int)Configuration::get('PS_COUNTRY_DEFAULT'));
			$stores = $this->loadAllStores();
			$this->context->smarty->assign(array(
			'img_store_dir' => _THEME_STORE_DIR_,
			'img_ps_dir' => $protocol_link.Tools::getMediaServer(_PS_IMG_)._PS_IMG_,
			'cookie' => $this->context->cookie,
			'base_dir'=> _PS_BASE_URL_.__PS_BASE_URI__,
			'api_key' => $api_key,
			'http' => $_http,
			'region' => Tools::substr($default_country->iso_code, 0, 2),
			'_stores' => $stores,
			'sl_url' => $this->context->link->getPageLink('search'),
			));
			$force_ssl = (Configuration::get('PS_SSL_ENABLED') && Configuration::get('PS_SSL_ENABLED_EVERYWHERE'));
            $this->context->smarty->assign(array(
                'base_dir' => _PS_BASE_URL_.__PS_BASE_URI__,
                'base_dir_ssl' => _PS_BASE_URL_SSL_.__PS_BASE_URI__,
                'force_ssl' => $force_ssl,
                )
            );
			$this->setTemplate('cms/stores_17.tpl');
		}
		else {
			$this->setTemplate(_PS_MODULE_DIR_.'storelocator/views/templates/front/stores.tpl');
		}
	}

	public function setMedia()
	{
		parent::setMedia();
		$api_key = Configuration::get('FMESL_KEY');
		if (Tools::version_compare(_PS_VERSION_, '1.7.0.0', '>=') == true) {
			$this->addCSS(_PS_BASE_URL_.__PS_BASE_URI__.'modules/storelocator/views/css/stores.css');
		}
		else {
			$this->addCSS(_THEME_CSS_DIR_.'stores.css');
		}
		if (!Configuration::get('PS_STORES_SIMPLIFIED') && Tools::version_compare(_PS_VERSION_, '1.7.0.0', '<') == true) {
			$this->addJqueryUI(array(
                'ui.core',
                'ui.widget'
            ));
			if (Configuration::get('PS_SSL_ENABLED') && Configuration::get('PS_SSL_ENABLED_EVERYWHERE')) {
				$this->addJS(_PS_BASE_URL_SSL_.__PS_BASE_URI__.'modules/storelocator/views/js/stores.js');
			} else {
				$this->addJS(_PS_BASE_URL_.__PS_BASE_URI__.'modules/storelocator/views/js/stores.js');
			}

		} elseif (!Configuration::get('PS_STORES_SIMPLIFIED') && Tools::version_compare(_PS_VERSION_, '1.7.0.0', '>=') == true) {
			if (Configuration::get('PS_SSL_ENABLED') && Configuration::get('PS_SSL_ENABLED_EVERYWHERE')) {
				$this->addJS(_PS_BASE_URL_SSL_.__PS_BASE_URI__.'modules/storelocator/views/js/stores_17.js');
			} else {
				$this->addJS(_PS_BASE_URL_.__PS_BASE_URI__.'modules/storelocator/views/js/stores_17.js');
			}
		}
		$default_country = new Country((int)Configuration::get('PS_COUNTRY_DEFAULT'));
		$this->addJS('http'.((Configuration::get('PS_SSL_ENABLED') && Configuration::get('PS_SSL_ENABLED_EVERYWHERE')) ? 's' : '').'://maps.google.com/maps/api/js?key='.$api_key.'&amp;region='.Tools::substr($default_country->iso_code, 0, 2));
	}
	
	public function getAllStores()
	{
		$id_product = Tools::getValue('id_product');
		$sql = 'SELECT t.*,s.iso_code
		FROM '._DB_PREFIX_.'store t
		LEFT JOIN  '._DB_PREFIX_.'state s ON s.id_state = t.id_state
		WHERE t.related_products LIKE "%'.(int)$id_product.'%" AND  t.`active` = 1
		ORDER BY t.id_store';
		return Db::getInstance()->executeS($sql);
	}
	
	public function loadAllStores()
	{
		$stores = Db::getInstance()->executeS('
			SELECT s.*, cl.name country, st.iso_code state
			FROM '._DB_PREFIX_.'store s
			'.Shop::addSqlAssociation('store', 's').'
			LEFT JOIN '._DB_PREFIX_.'country_lang cl ON (cl.id_country = s.id_country)
			LEFT JOIN '._DB_PREFIX_.'state st ON (st.id_state = s.id_state)
			WHERE s.active = 1 AND cl.id_lang = '.(int)$this->context->language->id);
		return $stores;
	}
}
