<?php
/**
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    FME Modules
*  @copyright 2018 FME Modules
*  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_')) {
	exit;
}

define('MAX_LINE_SIZE', 0);
define('MAX_COLUMNS', 12);
class Storelocator extends Module
{
	public $fields = array();

	public function __construct()
	{
		$this->name = 'storelocator';
		$this->tab = 'front_office_features';
		$this->version = '1.6.0';
		$this->author = 'FMM Modules';
		$this->need_instance = 0;
		$this->bootstrap = true;
		$this->module_key = 'f936a6cc644828c2adf1311513c76c86';
		parent::__construct();
		$this->displayName = $this->l('Store Locator');
		$this->description = $this->l('Adds extra features to your store locator.');
		$this->fields = array(
				'id_store'		=> $this->l('ID'),
				'name'			=> $this->l('Name').'*',
				'address1'		=> $this->l('Address').'*',
				'city'			=> $this->l('City').'*',
				'postcode'		=> $this->l('Zip code').'*',
				'id_state'		=> $this->l('ID State'),
				'id_country'	=> $this->l('ID Country'),
				'phone'			=> $this->l('Phone'),
				'fax'			=> $this->l('Fax'),
				'active'		=> $this->l('Enabled'),
				'latitude'		=> $this->l('Latitude'),
				'longitude'		=> $this->l('Longitude')
			);
	}

	public function install()
	{
		// Install Function for Module and Hooking it to Home
		Configuration::updateValue('FMESL_SEPARATOR', ',');
		Configuration::updateValue('FME_DISTANCE_UNIT', 'km');
		Configuration::updateValue('FMESL_ZOOM_VALUE', 10);
		return ($this->renameIndex()
				&& $this->moveFiles()
				&& parent::install()
				&& $this->registerHook('displayProductTab')
				&& $this->registerHook('displayProductTabContent')
				&& $this->registerHook('displayFooterProduct')
				&& $this->installDb()
				&& $this->copyDirectory(_PS_MODULE_DIR_.'storelocator/views/templates/admin', _PS_OVERRIDE_DIR_.'controllers/admin/templates'));
	}

	public function moveFiles()
	{ 
		/*Tools::copy(_PS_MODULE_DIR_.'storelocator/locate/AdminStoresController.php', _PS_OVERRIDE_DIR_.'controllers/admin/AdminStoresController.php');
		Tools::copy(_PS_MODULE_DIR_.'storelocator/locate/StoresController.php', _PS_OVERRIDE_DIR_.'controllers/front/StoresController.php');
		@Tools::copy(_PS_MODULE_DIR_.'storelocator/views/templates/front/stores_17.tpl', _PS_ROOT_DIR_.'/themes/'._THEME_NAME_.'/templates/cms/stores_17.tpl');*/
		return true;
	}

	public function delFiles()
	{
		/*@unlink(_PS_OVERRIDE_DIR_.'controllers/admin/AdminStoresController.php');
		@unlink(_PS_OVERRIDE_DIR_.'controllers/front/StoresController.php');
		@unlink(_PS_ROOT_DIR_.'/themes/'._THEME_NAME_.'/cms/stores_17.tpl');*/
		return true;
	}

	public function renameIndex()
	{
		//Rename Cache Index
		if (file_exists(_PS_CACHE_DIR_.'class_index.php'))
			rename(_PS_CACHE_DIR_.'class_index.php', _PS_CACHE_DIR_.'class_index'.rand(pow(10, 3 - 1), pow(10, 3) - 1).'.php');
		return true;
	}

	public function installDb()
	{
		//INSTALL Database
		$return = true;
		$return &= Db::getInstance()->execute(' ALTER TABLE `'._DB_PREFIX_.'store` ADD related_products TEXT NOT NULL;');
		return $return;			
	}

	public function uninstall()
	{
		//If Uninstallation required for Module
		return (parent::uninstall()
				&& $this->delFiles()
				&& $this->uninstallDB()
				&& @unlink(_PS_OVERRIDE_DIR_.'controllers/front/StoresController.php')
				&& @unlink(_PS_OVERRIDE_DIR_.'controllers/admin/AdminStoresController.php')
				&& $this->renameCache());
	}

	public function renameCache()
	{
		if (file_exists(_PS_CACHE_DIR_.'class_index.php')) {
			rename(_PS_CACHE_DIR_.'class_index.php', _PS_CACHE_DIR_.'__class_index.php');
		}
		rename(_PS_OVERRIDE_DIR_.'controllers/admin/templates/stores', _PS_OVERRIDE_DIR_.'controllers/admin/templates/stores'.rand(pow(10, 3 - 1), pow(10, 3) - 1));
		return true;	
	}

	public function uninstallDB()
	{
		//Removing Database
		return (Db::getInstance()->execute('ALTER TABLE `'._DB_PREFIX_.'store` DROP COLUMN related_products;'));
	}

	public function copyDirectory($src, $dst)
	{
		/*$dir = opendir($src);
		@mkdir($dst);
		while (false !== ($file = readdir($dir))) {
			if (($file != '.') && ($file != '..')) {
				if (is_dir($src.'/'.$file)) {
					$this->copyDirectory($src.'/'.$file, $dst.'/'.$file);
				}
				else {
					Tools::copy($src.'/'.$file, $dst.'/'.$file);
				}
			}
		}
		closedir($dir);*/
		return true;
	}

	public function getContent()
	{
		//Admin Side
		if (Tools::isSubmit('import_contacts')) {
			$link = $this->context->link->getAdminLink('AdminStores', 'true');
			$Index = $this->context->link->getAdminLink('AdminModules', false);
			$url = $Index.'&configure=storelocator&token='.Tools::getAdminTokenLite('AdminModules').'&tab_module=front_office_features&module_name=storelocator';
			$this->context->smarty->assign(
				array(
					'url'			=> $link,
					'version'		=> _PS_VERSION_,
					'fields'		=> $this->fields,
					'moduleLink'	=> $url,
					));
			return $this->_postProcess().$this->display(__FILE__, 'config.tpl');
		}
		else {
			return $this->_postProcess().$this->renderForm();
		}
	}

	public function renderForm()
	{
		if (Tools::version_compare(_PS_VERSION_, '1.6.0.0', '<') == true) {
			$image_url = _PS_IMG_DIR_.'logo_stores.gif';
			$image_url = ImageManager::thumbnail($image_url, 'logo_stores.gif', 30, 'gif', true, false);
			$warning = $this->context->controller->warnings[] = $this->l('You can get Google API key from ').'<a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">'.$this->l('HERE').'</a>';
		} else {
			$image_url = _PS_IMG_DIR_.'logo_stores.png';
			$image_url = ImageManager::thumbnail($image_url, 'logo_stores.png', 30, 'png', true, false);
			$warning = $this->displayWarning($this->l('You can get Google API key from ').'<a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">'.$this->l('HERE').'</a>');
		}
			if (Tools::version_compare(_PS_VERSION_, '1.6.0.0', '>=') == true) {
				$status_01 = array(
					'type' => 'switch',
					'label' => $this->l('Show Tab on Product page?'),
					'name' => 'FMESL_TABSTATE',
					'required' => false,
					'class' => 't',
					'is_bool' => true,
					'values' => array(
						array(
							'id' => 'rsa_on',
							'value' => 1,
							'label' => $this->l('Yes')
						),
						array(
							'id' => 'rsa_off',
							'value' => 0,
							'label' => $this->l('No')
							)
						),
					'hint' => $this->l('Enable this if you want to show block of stores related to product.')
					);
				$status_02 = array(
					'type' => 'switch',
					'label' => $this->l('Autolocate User Location?'),
					'name' => 'FMESL_USER',
					'required' => false,
					'class' => 't',
					'is_bool' => true,
					'desc' => $this->l('NOTE: It will only work if you have HTTPS connection on frontend.'),
					'values' => array(
						array(
							'id' => 'rsa_on',
							'value' => 1,
							'label' => $this->l('Yes')
						),
						array(
							'id' => 'rsa_off',
							'value' => 0,
							'label' => $this->l('No')
							)
						),
					'hint' => $this->l('Enabling this will autodetect user location.')
					);
				$status_03 = array(
					'type' => 'switch',
					'label' => $this->l('Allow Search by Product?'),
					'name' => 'FMESL_SBP',
					'required' => false,
					'class' => 't',
					'is_bool' => true,
					'values' => array(
						array(
							'id' => 'rsa_on',
							'value' => 1,
							'label' => $this->l('Yes')
						),
						array(
							'id' => 'rsa_off',
							'value' => 0,
							'label' => $this->l('No')
							)
						)
					);
				$status_04 = array(
					'type' => 'switch',
					'label' => $this->l('Show Reset Button?'),
					'name' => 'FMESL_RESET',
					'required' => false,
					'class' => 't',
					'is_bool' => true,
					'values' => array(
						array(
							'id' => 'rsa_on',
							'value' => 1,
							'label' => $this->l('Yes')
						),
						array(
							'id' => 'rsa_off',
							'value' => 0,
							'label' => $this->l('No')
							)
						)
					);
			} else {
				$status_01 = array(
					'type' => 'radio',
					'label' => $this->l('Show Tab on Product page?'),
					'name' => 'FMESL_TABSTATE',
					'required' => false,
					'class' => 't',
					'is_bool' => true,
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Enabled')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('Disabled')
						)
					),
				);
				$status_02 = array(
					'type' => 'radio',
					'label' => $this->l('Autolocate User Location?'),
					'name' => 'FMESL_USER',
					'required' => false,
					'class' => 't',
					'is_bool' => true,
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Enabled')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('Disabled')
						)
					),
				);
				$status_03 = array(
					'type' => 'radio',
					'label' => $this->l('Allow Search by Product?'),
					'name' => 'FMESL_SBP',
					'required' => false,
					'class' => 't',
					'is_bool' => true,
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Enabled')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('Disabled')
						)
					),
				);
				$status_04 = array(
					'type' => 'radio',
					'label' => $this->l('Show Reset Button?'),
					'name' => 'FMESL_RESET',
					'required' => false,
					'class' => 't',
					'is_bool' => true,
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Enabled')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('Disabled')
						)
					),
				);
			}
		$dist_type = array(
            array(
                'id' => 'mi',
                'name' => $this->l('mile')
            ),
            array(
                'id' => 'km',
                'name' => $this->l('kilometer')
            ),
        );
		$str_layout = array(
            array(
                'id' => 0,
                'name' => $this->l('1 Column')
            ),
            array(
                'id' => 2,
                'name' => $this->l('2 Column Right')
            ),
			array(
                'id' => 1,
                'name' => $this->l('2 Column Left')
            ),
			array(
                'id' => 3,
                'name' => $this->l('3 Column')
            ),
        );
		$fields_form = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Settings'),
					'icon' => 'icon-cogs'
				),
				'input' => array(
					array(
						'type' => 'text',
						'lang' => true,
						'label' => $this->l('Store Page Title:'),
						'name' => 'FMESL_PAGE_TITLE',
						'hint' => $this->l('Forbidden characters: &amp;lt;&amp;gt;;=#{}')
					),
					array(
						'type' => 'text',
						'lang' => false,
						'label' => $this->l('Latitude by default:'),
						'name' => 'PS_STORES_CENTER_LAT',
						'required' => true,
						'hint' => $this->l('Current view of map.'),
						'placeholder' => 25.765005
					),
					array(
						'type' => 'text',
						'lang' => false,
						'label' => $this->l('Longitude by default:'),
						'name' => 'PS_STORES_CENTER_LONG',
						'required' => true,
						'hint' => $this->l('Current view of map.'),
						'placeholder' => -80.24379700
					),
					array(
						'type' => 'text',
						'lang' => false,
						'label' => $this->l('Google API Key:'),
						'name' => 'FMESL_KEY',
						'required' => true,
						'hint' => $this->l('See above warning to find key')
					),
					array(
						'type' => 'text',
						'lang' => false,
						'label' => $this->l('Default Zoom Level:'),
						'name' => 'FMESL_ZOOM_VALUE',
						'required' => false,
						'desc' => $this->l('Zoom range is from 0 which is lowest and 21 is the highest.'),
						'hint' => $this->l('Default zoom level view of map. Use from 0 to 20.'),
						'placeholder' => 10
					),
					array(
						'type' => 'text',
						'lang' => false,
						'label' => $this->l('CSV Separator:'),
						'name' => 'FMESL_SEPARATOR',
						'desc' => $this->l('This will be only used during import of stores through CSV file.'),
						'hint' => $this->l('Use , ; : | default is comma')
					),
					array(
						'type' => 'select',
						'label' => $this->l('Distance Unit:'),
						'name' => 'FME_DISTANCE_UNIT',
						'options' => array(
							'query' => $dist_type,
							'id' => 'id',
							'name' => 'name'
						),
					),
					$status_01,
					array(
						'type' => 'text',
						'lang' => true,
						'label' => $this->l('Tab Title:'),
						'name' => 'FMESL_TAB',
						'hint' => $this->l('In case if you want to show stores block on product.')
					),
					array(
						'type' => 'text',
						'lang' => true,
						'label' => $this->l('Tab Heading:'),
						'name' => 'FMESL_TABHEAD',
						'hint' => $this->l('In case if you want to show stores block on product.')
					),
					$status_02,
					$status_03,
					$status_04,
					(Tools::version_compare(_PS_VERSION_, '1.7.0.0', '<') == true) ? array(
						'type' => 'select',
						'label' => $this->l('Store Page Layout:'),
						'name' => 'FMESL_LAYOUT',
						'options' => array(
							'query' => $str_layout,
							'id' => 'id',
							'name' => 'name'
						),
					) : array('type' => 'hidden', 'name' => 'FMESL_LAYOUT'),
					array(
						'type' => 'file',
						'label' => $this->l('Store Map Icon'),
						'name' => 'img',
						'display_image' => true,
						'image' => $image_url ? $image_url : false,
						'size' => 300,
						'hint' => $this->l('Upload an Image type PNG from your computer.'),
					),
				),
				'submit' => array(
					'title' => $this->l('Save')
				)
			),
		);

		$helper = new HelperForm();
		$helper->show_toolbar = false;
		$helper->table = $this->table;
		$lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
		$helper->default_form_language = $lang->id;
		$helper->module = $this;
		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
		$helper->identifier = $this->identifier;
		$helper->submit_action = 'submit'.$this->name;
		$helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->tpl_vars = array(
			'uri' => $this->getPathUri(),
			'fields_value' => $this->getConfigFieldsValues(),
			'languages' => $this->context->controller->getLanguages(),
			'id_language' => $this->context->language->id
		);
		return $warning.$helper->generateForm(array($fields_form));
	}
	
	public function getConfigFieldsValues()
	{
		$fields = array();
		$languages = Language::getLanguages(false);
		foreach ($languages as $lang) {
			$fields['FMESL_TAB'][$lang['id_lang']] = Tools::getValue('FMESL_TAB_'.$lang['id_lang'], Configuration::get('FMESL_TAB', $lang['id_lang']));
			$fields['FMESL_TABHEAD'][$lang['id_lang']] = Tools::getValue('FMESL_TABHEAD_'.$lang['id_lang'], Configuration::get('FMESL_TABHEAD', $lang['id_lang']));
			$fields['FMESL_PAGE_TITLE'][$lang['id_lang']] = Tools::getValue('FMESL_PAGE_TITLE_'.$lang['id_lang'], Configuration::get('FMESL_PAGE_TITLE', $lang['id_lang']));
		}
		$fields['FMESL_KEY'] = Configuration::get('FMESL_KEY');
		$fields['FMESL_SEPARATOR'] = Configuration::get('FMESL_SEPARATOR');
		$fields['FME_DISTANCE_UNIT'] = Configuration::get('FME_DISTANCE_UNIT');
		$fields['FMESL_TABSTATE'] = (int)Configuration::get('FMESL_TABSTATE');
		$fields['FMESL_USER'] = (int)Configuration::get('FMESL_USER');
		$fields['FMESL_SBP'] = (int)Configuration::get('FMESL_SBP');
		$fields['FMESL_RESET'] = (int)Configuration::get('FMESL_RESET');
		$fields['FMESL_LAYOUT'] = (int)Configuration::get('FMESL_LAYOUT');
		$fields['PS_STORES_CENTER_LONG'] = Configuration::get('PS_STORES_CENTER_LONG');
		$fields['PS_STORES_CENTER_LAT'] = Configuration::get('PS_STORES_CENTER_LAT');
		$fields['FMESL_ZOOM_VALUE'] = Configuration::get('FMESL_ZOOM_VALUE');
		return $fields;
	}
	
	private function _postProcess()
	{
		$languages = Language::getLanguages(false);
		$values = array();
		// If Needed to Update the Settings
		if (Tools::isSubmit('submit'.$this->name)) {
			foreach ($languages as $lang) {
				$values['FMESL_TAB'][$lang['id_lang']] = Tools::getValue('FMESL_TAB_'.$lang['id_lang']);
				$values['FMESL_TABHEAD'][$lang['id_lang']] = Tools::getValue('FMESL_TABHEAD_'.$lang['id_lang']);
				$values['FMESL_PAGE_TITLE'][$lang['id_lang']] = Tools::getValue('FMESL_PAGE_TITLE_'.$lang['id_lang']);
			}
			Configuration::updateValue('FMESL_TAB', $values['FMESL_TAB']);
			Configuration::updateValue('FMESL_TABHEAD', $values['FMESL_TABHEAD']);
			Configuration::updateValue('FMESL_PAGE_TITLE', $values['FMESL_PAGE_TITLE']);
			Configuration::updateValue('FMESL_LAYOUT', (int)Tools::getValue('FMESL_LAYOUT'));
			Configuration::updateValue('PS_DISTANCE_UNIT', Tools::getValue('FME_DISTANCE_UNIT'));
			Configuration::updateValue('FME_DISTANCE_UNIT', Tools::getValue('FME_DISTANCE_UNIT'));
			Configuration::updateValue('FMESL_TABSTATE', (int)Tools::getValue('FMESL_TABSTATE'));
			Configuration::updateValue('FMESL_USER', (int)Tools::getValue('FMESL_USER'));
			Configuration::updateValue('FMESL_RESET', (int)Tools::getValue('FMESL_RESET'));
			Configuration::updateValue('FMESL_SBP', (int)Tools::getValue('FMESL_SBP'));
			Configuration::updateValue('FMESL_ZOOM_VALUE', (int)Tools::getValue('FMESL_ZOOM_VALUE'));
			Configuration::updateValue('FMESL_KEY', Tools::getValue('FMESL_KEY'));
			Configuration::updateValue('FMESL_SEPARATOR', Tools::getValue('FMESL_SEPARATOR'));
			Configuration::updateValue('PS_STORES_CENTER_LAT', Tools::getValue('PS_STORES_CENTER_LAT'));
			Configuration::updateValue('PS_STORES_CENTER_LONG', Tools::getValue('PS_STORES_CENTER_LONG'));
			$file = Tools::fileAttachment('img');
			if (!empty($file['name'])) {
				$file['type'] = explode('/', $file['mime']);
				$file['type'] = end($file['type']);
				if (ImageManager::validateUpload($file, Tools::convertBytes(ini_get('upload_max_filesize')))) {
					return $this->displayWarning($this->l('Image size exceeds limit in your PrestaShop settings'));
				} else {
					ImageManager::resize($file['tmp_name'], _PS_IMG_DIR_.'logo_stores.png', 30, 30, 'png', false);
					ImageManager::resize($file['tmp_name'], _PS_IMG_DIR_.'tmp/logo_stores.png', 30, 30, 'png', false);
					if (Tools::version_compare(_PS_VERSION_, '1.6.0.0', '<') == true) {
						ImageManager::resize($file['tmp_name'], _PS_IMG_DIR_.'logo_stores.gif', 30, 30, 'gif', false);
						ImageManager::resize($file['tmp_name'], _PS_IMG_DIR_.'tmp/logo_stores.gif', 30, 30, 'gif', false);
					}
				}
			}
			return $this->displayConfirmation($this->l('The settings have been updated.'));
		}
		elseif (Tools::isSubmit('importStoreContacts')) {
			$this->renderCSV();
		}
		elseif (Tools::isSubmit('importContacts')) {
			$this->processCSV();
		}
	}

	protected function processCSV()
	{
		if ($_FILES['csv'] && $_FILES['csv']['name']) {
			$separator = (Configuration::get('FMESL_SEPARATOR')) ? Configuration::get('FMESL_SEPARATOR') : ',';
			$file = $_FILES['csv']['tmp_name'];
			$handle	= $this->openCSV($file);
			$nb_column = $this->getNbrColumn($handle, $separator);
			$data = array();
			$content = array();
			$html = '';

			ini_set('auto_detect_line_endings', true);
			
			$rows = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
			$no_of_rows	= count($rows);

			$data['head'] = explode($separator, $rows[0]);
			for ($i = 1; $i < $no_of_rows; $i++) {
				$data['content'][$i] = explode($separator, $rows[$i]);
			}
			$no_of_cols	= count($data['head']);
			for ($i = 1; $i < $no_of_rows; $i++) {
				for ($j = 0; $j < $no_of_cols; $j++) {
					$content[$i - 1][$data['head'][$j]] = $data['content'][$i][$j];
				}
			}
			$html .= '<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post" enctype="multipart/form-data" class="well">
							<input type="hidden" name="nb_rows" value="'.$no_of_rows.'" />
							<input type="hidden" name="nb_cols" value="'.$no_of_cols.'" />
							<table>
								<thead>
									<tr>';
			for ($i = 0; $i < $nb_column; $i++) {
				// displaying maximum columns
					if ($i == MAX_COLUMNS) {
						break;
					}
					$html 	.= '<th class="center" style="background:#F1F1F1;">
									<select name="head_'.$i.'" style="background:#fff;font-weight: bold;padding: 2px;width: 100%;">
										<option value="0" selected="selected"> - </option>';
										foreach ($this->fields as $key => $value)
					$html 	.= '<option value="'.$key.'">'.$value.'</option>';
					$html 	.= '</select>
									</th>';
			}
			
			$html .=	'</tr>
						<tr>';
			for ($i = 0; $i < $nb_column; $i++) {
				// displaying maximum columns
					if ($i == MAX_COLUMNS) {
						break;
					}
					$html .= '<th class="center" style="background:#F1F1F1;padding-left: 5px">'.$data['head'][$i].'</th>';
			}
			$html .= '</tr>
						</thead>
						<tbody>';
			foreach ($content as $line) {
				$count = 0;
				$html .= '<tr>';
				foreach ($line as $value) {
						if ($count == MAX_COLUMNS) {
							break;
						}
						$html 	.= ' <input id="col_'.$count.'" type="hidden" value="'.$value.'" name="col_'.$count.'[]"/><td style="padding-left: 5px">'.$value.'</td>';
						$count ++;
					}	
				$html .= '</tr>';
			}
			$html .= '<tr>
						</tr>
						</tbody>
						<tfoot>
						</tfoot>
						<tr><td colspan="12"><hr/><div class="clearfix"></div></td></tr>
						<tr><td colspan="12">
							<div class="margin-form form-group">
								<button id="import-button" name="importStoreContacts" class="btn btn-default pull-right" type="submit"><i class="process-icon-next"></i>'.$this->l('Import data').'</button>
							</div></td></tr>
						</table>
						</form>';
		echo Tools::jsonEncode($html);
		die();	
		}
	}

	protected function renderCSV()
	{
			$cols_no = Tools::getValue('nb_cols');
			$rows_no = Tools::getValue('nb_rows');

			//limiting to display maximum columns
			if ($cols_no > MAX_COLUMNS) {
				$cols_no = MAX_COLUMNS;
			}

			$col_head = array();
			$col_N = array();
			$required_fields = 0;
			for ($i = 0; $i < $cols_no; $i++) {
				$col_head[]	= Tools::getValue('head_'.$i);
				$col_N[$col_head[$i]] = Tools::getValue('col_'.$i);
				
				if ($col_head[$i] == 'address1' || $col_head[$i] == 'city' || $col_head[$i] == 'name') {
					$required_fields ++;
				}
			}

			// checking for seven mandatory fields i.e. address,city,zipcode,id_state,id_country,latitude,longitude
			if ($required_fields < 3) {
				// redirect to controller and display error message
				$link = $this->context->link->getAdminLink('AdminStores', true).'&required_fields_error';
				Tools::redirectAdmin($link);
			}
			else {
				$skip = 0;
				$inserted = 0;
				// optional fields
				$name = '';
				$fax = '';
				$phone = '';
				$enabled = '';
				// required fields
				$address = '';
				$city = '';
				$zipcode = '';
				$id_state = '';
				$id_country = '';
				$latitude = '';
				$longitude = '';
	
				for ($i = 0; $i < $rows_no - 1; $i++) {
					$date_add = date('Y-m-d H:i:s');
					
					// assigning values to optional fields
					if (isset($col_N['name'][$i])) {
						$name = $col_N['name'][$i];
					}
					if (isset($col_N['fax'][$i])) {
						$fax = $col_N['fax'][$i];
					}
					if (isset($col_N['phone'][$i])) {
						$phone = $col_N['phone'][$i];
					}
					if (isset($col_N['active'][$i])) {
						$enabled = $col_N['active'][$i];
					}
					if (isset($col_N['id_state'][$i])) {
						$id_state	= $col_N['id_state'][$i];
					}
					// assigning values to required fields
					$address = $col_N['address1'][$i];
					$city = $col_N['city'][$i];
					$zipcode = $col_N['postcode'][$i];

					$co = $this->getLatLong($address);
	
					if (isset($co) && isset($co['lat']) && isset($co['long'])) {
						$latitude = (float)$co['lat'];
						$longitude = (float)$co['long'];
						$id_country = (int)Country::getByIso($co['iso']);
					}

					if ($id_country && !empty($address) && !empty($city) && !empty($name)) {
						$this->addStoreContact($id_country, $id_state, $name, $address, $city, $zipcode, $latitude, $longitude, $phone, $fax, $enabled, $date_add);
						$inserted ++;							
					}
					else {
						$skip ++;
					}
				}
				$link = $this->context->link->getAdminLink('AdminStores', true).'&inserted='.$inserted.'&skip='.$skip.'&info';
				Tools::redirectAdmin($link);
			}
	}

	protected function getLatLong($address)
	{
		// $prep_addr = str_replace(' ','+', $address);
		$geocode = Tools::file_get_contents('https://maps.google.com/maps/api/geocode/json?key='.Configuration::get('FMESL_KEY').'&address='.urlencode($address).'&sensor=false');
		$geo = Tools::jsonDecode($geocode);
		$result = array();

		if ($geo->status = 'OK') {
			$latitude = $geo->results[0]->geometry->location->lat;
			$longitude = $geo->results[0]->geometry->location->lng;

			$c_iso = $this->context->country->iso_code;
			foreach ($geo->results[0]->address_components as $comp) {
				if ($comp->types[0] == 'country') {
					$c_iso = $comp->short_name;
				}
			}
			$result = array('lat' => $latitude, 'long' => $longitude, 'iso' => $c_iso);
		}
		return $result;
	}

	protected function openCSV($file)
	{
		// open csv file
		$handle = false;
		if (is_file($file) && is_readable($file)) {
			$handle = fopen($file, 'r');
		}

		if (!$handle) {
			$this->errors[] = Tools::displayError('Cannot read the .CSV file');
		}

		$this->rewindBomAware($handle);

		for ($i = 0; $i < (int)Tools::getValue('skip'); ++$i) {
			fgetcsv($handle, MAX_LINE_SIZE, $this->separator);
		}
		return $handle;
	}

	protected function getNbrColumn($handle, $glue = ',')
	{
		if (!is_resource($handle)) {
			return false;
		}
		$tmp = fgetcsv($handle, MAX_LINE_SIZE, $glue);
		$this->rewindBomAware($handle);
		return count($tmp);
	}

	protected static function rewindBomAware($handle)
	{
		// A rewind wrapper that skips BOM signature wrongly
		if (!is_resource($handle)) {
			return false;
		}
		rewind($handle);
		if ((fread($handle, 3)) != "\xEF\xBB\xBF") {
			rewind($handle);
		}
	}

	public function hookDisplayProductTab($params)
	{
		//For Left Column
		$this->context->smarty->assign(
			array(
				'FMESL_TAB' => Configuration::get('FMESL_TAB', $this->context->language->id),
				'FMESL_TABHEAD' => Configuration::get('FMESL_TABHEAD', $this->context->language->id),
				'FMESL_TABSTATE' => (int)Configuration::get('FMESL_TABSTATE'),
				'PS_VERSION' => _PS_VERSION_
				)
			);
		return $this->display(__FILE__, 'tabs.tpl');
	}

	public function hookDisplayProductTabContent($params)
	{
		$stores = $this->getStores();
		$id_product = Tools::getValue('id_product');
		$this->context->smarty->assign(
			array(
				'stores' => $stores,
				'id_product' => $id_product,
				'FMESL_TABSTATE' => (int)Configuration::get('FMESL_TABSTATE'),
				));
		return $this->display(__FILE__, 'tabcontent.tpl');
	}

	public function getStores()
	{
		$id_product = Tools::getValue('id_product');
		$sql = 'SELECT t.*
			FROM '._DB_PREFIX_.'store t
			WHERE t.related_products LIKE "%'.(int)$id_product.'%" AND  t.`active` = 1
			ORDER BY t.id_store';
		return Db::getInstance()->executeS($sql);
	}

	protected function addStoreContact($id_country, $id_state, $name = null, $address1, $city, $postcode, $latitude, $longitude, $phone = null, $fax = null, $active = 1, $date_add)
	{
		$sql = 'INSERT INTO `'._DB_PREFIX_.'store` (`id_country`, `id_state`, `name`, `address1`, `city`, `postcode`, `latitude`, `longitude`, `phone`, `fax`, `active`, `date_add`)
				VALUES ('.pSQL((int)$id_country).', '.pSQL((int)$id_state).', "'.pSQL($name).'", "'.pSQL($address1).'", "'.pSQL($city).'", "'.$postcode.'", '.pSQL((float)$latitude).', '.pSQL((float)$longitude).', "'.pSQL($phone).'", "'.pSQL($fax).'", '.pSQL((int)$active).', "'.pSQL($date_add).'")';
			Db::getInstance()->execute($sql);
		$return = (int)Db::getInstance()->Insert_ID();
		return Db::getInstance()->execute('
		INSERT INTO '._DB_PREFIX_.'store_shop (`id_shop`, `id_store`)
		VALUES(1, '.(int)$return.')
		');
	}

	public function hookDisplayFooterProduct()
	{
		if (Tools::version_compare(_PS_VERSION_, '1.7.0.0', '>=') == true) {
			$lang_id = $this->context->language->id;
			$stores = $this->getStores();
			$id_product = Tools::getValue('id_product');
			$force_ssl = (Configuration::get('PS_SSL_ENABLED') && Configuration::get('PS_SSL_ENABLED_EVERYWHERE'));
			$this->context->smarty->assign(
			array(
				'stores' => $stores,
				'id_product' => $id_product,
				'FMESL_TABSTATE' => (int)Configuration::get('FMESL_TABSTATE'),
                'base_dir' => _PS_BASE_URL_.__PS_BASE_URI__,
                'base_dir_ssl' => _PS_BASE_URL_SSL_.__PS_BASE_URI__,
                'force_ssl' => $force_ssl,
				'FMESL_TABHEAD' => Configuration::get('FMESL_TAB', $lang_id),
				'FMESL_TABHEAD_SUB' => Configuration::get('FMESL_TABHEAD', $lang_id)
			));
			return $this->display(__FILE__, 'product_stores.tpl');
		}
		else {
			return;
		}
	}
}